;********************************************;
; WASM Video Module, Initialization Routines ;
; By Eric Tauck                              ;
;                                            ;
; Defines:                                   ;
;                                            ;
;   ModDim   return the screen dimensions    ;
;   ModGet   return the current mode         ;
;   VidInit  initialize the video routines   ;
;********************************************;

        jmp     _video1_end

;========================================
; Symbolic modes.

TEXT4012        EQU     1       ;40 columns, 12 rows
TEXT4014        EQU     2       ;40 columns, 14 rows
TEXT4021        EQU     3       ;40 columns, 21 rows
TEXT4025        EQU     4       ;40 columns, 25 rows
TEXT4028        EQU     5       ;40 columns, 28 rows
TEXT4043        EQU     6       ;40 columns, 43 rows
TEXT4050        EQU     7       ;40 columns, 50 rows
TEXT8012        EQU     8       ;80 columns, 12 rows
TEXT8014        EQU     9       ;80 columns, 14 rows
TEXT8021        EQU     10      ;80 columns, 21 rows
TEXT8025        EQU     11      ;80 columns, 25 rows
TEXT8028        EQU     12      ;80 columns, 28 rows
TEXT8043        EQU     13      ;80 columns, 43 rows
TEXT8050        EQU     14      ;80 columns, 50 rows

;========================================
; Global video data.

_vid_CVIS        EQU     01H            ;curor is visible flag
_vid_CACT        EQU     02H            ;curor is active flag
_vid_flags       DB      0              ;current video flags

_vid_colrows     LABEL   WORD
_vid_cols        DB      ?              ;current column
_vid_rows        DB      ?              ;current row

_vid_page        DB      ?              ;video page

_vid_con         DW      ?              ;cursor-on scan pattern
_vid_coff        DW      ?              ;cursor-off scan pattern
_vid_curadv      DB      ?              ;cursor advance

_vid_attr        DB      ?              ;current attribute

_vid_colrow      LABEL   WORD
_vid_col         DB      ?              ;current column
_vid_row         DB      ?              ;current row

_vid_base        DW      ?              ;base offset
_vid_addr        LABEL   DWORD          ;current address
_vid_addroff     DW      ?              ;  offset
_vid_addrseg     DW      ?              ;  segment

;========================================
; Determine the current screen mode
; dimensions.
;
; Out: AH= rows; AL= columns.

ModDim  PROC   NEAR
        mov     ah, 15          ;get video information function
        int     10H             ;execute
        push    ax              ;save columns
        mov     al, 25          ;default rows
        push    ax              ;save that

;--- get EGA/VGA row information

        mov     ah, 12H         ;EGA alternate function
        mov     bl, 10H         ;information subfunction
        int     10H             ;execute
        cmp     bl, 10H         ;check if EGA or VGA present
        je      _mddim1         ;jump if not
        push    bp
        push    es
        mov     ax, 1130H       ;get font info function
        sub     bh, bh          ;font pointer (just in case)
        int     10H             ;execute
        pop     es
        pop     bp
        pop     ax              ;drop old value
        inc     dl              ;increment rows
        push    dx

;--- finished

_mddim1 pop     dx              ;restore rows
        mov     ah, dl          ;return in AH
        pop     dx              ;restore columns
        mov     al, dh          ;return in AL
        ret
        ENDP

;========================================
; Get the current mode.
;
; Out: AL= mode; CY= set if error.

ModGet  PROC    NEAR
        push    di

;--- make sure in valid mode (i.e. not graphics)

        mov     ah, 15                  ;get video information function
        int     10H                     ;execute

        mov     cx, 5                   ;number of valid modes
        mov     di, OFFSET _vid_validtex ;address of table
        cld
        repne                           ;repeat until found
        scasb                           ;scan
        jne     _mdget1                 ;jump if error

;--- determine text mode

        call    ModDim                  ;get current dimesions
        mov     cx, 14                  ;load number of modes
        mov     di, OFFSET _vid_texmodes ;address of table
        cld
        repne                           ;repeat until found
        scasw                           ;scan
        jne     _mdget1                 ;jump if error
        mov     ax, cx                  ;return mode
        inc     ax                      ;adjust mode
        pop     di
        clc
        ret

;--- error

_mdget1 sub     ax, ax                  ;return 0
        pop     di
        stc
        ret

;--- data
_vid_validtex   DB      0, 1, 2, 3, 7
_vid_texmodes   DW      (50*256)+80, (43*256)+80, (28*256)+80
                DW      (25*256)+80, (21*256)+80, (14*256)+80
                DW      (12*256)+80, (50*256)+40, (43*256)+40
                DW      (28*256)+40, (25*256)+40, (21*256)+40
                DW      (14*256)+40, (12*256)+40
        ENDP

;========================================
; Set current video address.
;
; In: AH= row; AL= column.

_vid_setaddr PROC NEAR
        mov     dl, al          ;save column
        mov     al, ah          ;put row in AL
        mul     al, _vid_cols   ;row times columns
        sub     dh, dh          ;DX has columns
        add     ax, dx          ;add columns
        shl     ax              ;offset from start of buffer
        add     ax, _vid_base   ;add base address
        mov     _vid_addroff, ax ;save offset
        ret
        ENDP

;========================================
; Initialize video data.
;
; Out: CY= set if error.

VidInit PROC   NEAR
        call    ModDim          ;get screen dimensions
        mov     _vid_colrows, ax ;save columns and rows

        mov     ah, 0FH         ;get video info function
        int     10H             ;execute
        mov     _vid_page, bh   ;save page

        mov     cx, 5                   ;number of valid hardware modes
        mov     bx, OFFSET _vid_addrs   ;address of mode data

_vdini1 cmp     [bx], al        ;check if mode matches
        je      _vdini3         ;exit loop if so
        add     bx, 4           ;next entry
        loop    _vdini1         ;loop back if more

;--- error

_vdini2 stc
        ret

;--- base screen address

_vdini3 push    WORD [bx+2]
        pop     _vid_addrseg            ;set video segment

        call    ModGet                  ;get current mode
        jc      _vdini2
        mov     bl, al
        dec     bl
        sub     bh, bh
        shl     bx                      ;times two, page size table offset

        mov     al, _vid_page           ;current page
        sub     ah, ah
        mul     ax, [_vid_psize+bx]     ;offset to current page
        mov     _vid_base, ax           ;save base offset

;--- starting cursor location

        mov     ah, 3                   ;cursor location function
        mov     bh, _vid_page           ;current page
        int     10H                     ;execute
        mov     _vid_con, cx            ;save cursor-on scan pattern
        mov     _vid_coff, 2000H        ;cursor-off scan pattern
        or      _vid_flags, _vid_CVIS or _vid_CACT  ;set cursor flags
        mov     ax, dx
        mov     _vid_colrow, ax         ;save column and row
        call    _vid_setaddr            ;set cursor address

;--- current attribute

        mov     ah, 8           ;read character/attribute function
        mov     bh, _vid_page   ;current page
        int     10H             ;execute
        mov     _vid_attr, ah   ;save

;--- done

        clc
        ret

;--- base addresses of the hardware modes

_vid_addrs LABEL WORD
        DW      00H, 0B800H
        DW      01H, 0B800H
        DW      02H, 0B800H
        DW      03H, 0B800H
        DW      07H, 0B000H

;--- page sizes of the video modes

_vid_psize LABEL WORD
        DW      40 * 12 * 2 + 256       ;M4012
        DW      40 * 14 * 2 + 256       ;M4014
        DW      40 * 21 * 2 + 256       ;M4021
        DW      800H                    ;M4025, on most adapters
        DW      40 * 28 * 2 + 256       ;M4028
        DW      40 * 43 * 2 + 256       ;M4043
        DW      40 * 50 * 2 + 256       ;M4050
        DW      80 * 12 * 2 + 256       ;M8012
        DW      80 * 14 * 2 + 256       ;M8014
        DW      80 * 21 * 2 + 256       ;M8021
        DW      1000H                   ;M8025, on most adapters
        DW      80 * 28 * 2 + 256       ;M8028
        DW      80 * 43 * 2 + 256       ;M8043
        DW      80 * 50 * 2 + 256       ;M8050

        ENDP

_video1_end
