;**************************************;
; WASM Parameter Module                ;
; By Eric Tauck                        ;
;                                      ;
; Defines:                             ;
;                                      ;
;   ParRes  reset the parameter reader ;
;   ParGet  get the next parameter     ;
;**************************************;

        call    ParRes          ;reset parameters
        jmps    _parms_end

;--- data

_par_next       DW      ?       ;address of next parameter
_par_bytes      DB      ?       ;bytes left in line

;========================================
; Find non-delimiter.
;
; In: BX= pointer; CX= byte count.
;
; Out: BX,CX= updated; CY= set if not
;      found.

_par_skipdel PROC NEAR
        jcxz    _prskp2         ;exit if no bytes left
_prskp1 cmp     BYTE [bx], ' '  ;check if space or control character
        ja      _prskp3         ;exit loop if not
        inc     bx              ;next character
        loop    _prskp1         ;loop
_prskp2 stc
        ret
_prskp3 clc
        ret
        ENDP

;========================================
; Find a delimiter.
;
; In: BX= pointer; CX= byte count.
;
; Out: BX,CX= updated.

_par_finddel PROC NEAR
_prfin1 cmp     BYTE [bx], ' '  ;check if space or control character
        jbe     _prfin2         ;exit loop if not
        inc     bx              ;next character
        loop    _prfin1         ;decrement count
_prfin2 ret
        ENDP

;========================================
; Reset the parameter pointer so the
; first parameter is returned next.

ParRes  PROC   NEAR
        mov     _par_next, 81H  ;save address
        mov     al, [80H]
        mov     _par_bytes, al  ;save bytes
        ret
        ENDP

;========================================
; Return address of next parameter.
;
; Out: AX= address of next parameter; CY=
;      set if no parameter returned.

ParGet  PROC   NEAR
        mov     bx, _par_next
        mov     cl, _par_bytes
        sub     ch, ch
        call    _par_skipdel    ;skip delimiters
        jc      _prget1
        push    bx
        call    _par_finddel    ;find delimter
        mov     BYTE [bx], 0    ;store terminator
        mov     _par_next, bx   ;save address
        mov     _par_bytes, cl  ;save bytes left
        pop     ax
        clc
_prget1 ret
        ENDP

_parms_end
