;************************************************************************
; Speed Directory
; by Eric Tauck
;
; This program quickly changes the current directory, similarly to NCD.

        INCLUDE 'c:\src\wasm\case1.asm'
        INCLUDE 'c:\src\wasm\case2.asm'
        INCLUDE 'c:\src\wasm\enviro.asm'
        INCLUDE 'c:\src\wasm\file.asm'
        INCLUDE 'c:\src\wasm\memory.asm'
        INCLUDE 'c:\src\wasm\message1.asm'
        INCLUDE 'c:\src\wasm\parms.asm'
        INCLUDE 'c:\src\wasm\stack.asm'
        INCLUDE 'c:\src\wasm\string.asm'
        INCLUDE 'c:\src\wasm\stringf.asm'
        INCLUDE 'c:\src\wasm\start.asm'

        UNUSED+

RECSIZ  EQU     43                      ;search record size
DIRSIZ  EQU     0FFF0h                  ;maximum directory size (even number)
MAXDIR  EQU     256                     ;maximum directory length
BEGLEN  EQU     26 * 2 * 2              ;26 letters * 2 entries * word size

ENTER   EQU     01h                     ;enter directory
LEAVE   EQU     02h                     ;leave directory
FINISH  EQU     03h                     ;end of path

;========================================================================
; Start of program.

;--- trap critical error

        mov     ax, 2524h               ;set interrupt 24
        mov     dx, OFFSET Critical     ;routine address
        int     21h                     ;execute

;--- initialize

        call    Name_Table              ;get file name
        mov     ax, OFFSET dirnam       ;name
        call    StrUpr                  ;convert to uppercase
        call    Load_Table              ;load table
        mov     treseg, ax              ;save segment
        jnc     main1
        mov     bp, OFFSET error1       ;memory error message
        or      ax, ax                  ;check if allocation error
        jz      main5                   ;jump if error
        or      flags, FNOLOAD          ;set flag
        call    Clear_Table             ;clear drive table

main1   sub     al, al                  ;zero table
        call    Reset_Drives            ;reset drives
        sub     al, al
        mov     di, OFFSET exclude      ;exclude table
        mov     cx, 26                  ;entries
        cld
        rep
        stosb                           ;reset table
        jmps    mainA

;--- drive letter

main2   mov     al, [bx]                ;load plus or minus
        inc     bx                      ;skip it
main3   mov     bp, OFFSET error2       ;default error message
        mov     bl, [bx]                ;load letter
        sub     bl, 'A'                 ;convert to number
        cmp     bl, 26                  ;check range
        jae     main5
        sub     bh, bh                  ;zero high byte
        mov     dx, OFFSET exclude      ;exclude table
        cmp     al, '-'                 ;check if minus
        je      main4
        mov     dx, OFFSET drives       ;drive table
        or      flags, FDRIVE           ;drive specified
main4   add     bx, dx                  ;table address
        mov     BYTE [bx], 0FFh         ;set flag
        jmp     mainA

;--- relay points

main5   jmp     mainG                   ;error relay
main6   jmp     WORD [di]               ;call routine

;--- process switch

main7   or      flags, FSWITCH          ;set flag
        push    ax
        call    StrUpr                  ;convert to uppercase
        pop     ax
        mov     di, OFFSET table        ;load start of table
main8   mov     bx, [di]                ;load string address
        call    StrCmp                  ;check if same
        inc     di                      ;skip to routine
        inc     di                      ;
        jnc     main6                   ;jump if match
        inc     di                      ;skip to next entry
        inc     di                      ;
        cmp     di, OPTEND              ;check if done
        jne     main8                   ;  loop back if not

        push    ax
        call    StrLen                  ;get length
        pop     bx
        cmp     BYTE [bx], '+'          ;check for plus
        je      main2
        cmp     BYTE [bx], '-'          ;check for minus
        je      main2
        cmp     ax, 2                   ;check length
        jne     main9
        mov     al, '+'                 ;include if no +/-
        cmp     BYTE [bx + 1], ':'      ;check if drive letter
        je      main3

main9   mov     bp, OFFSET error3       ;error
        xchg    bx, tardir              ;save directory name
        or      bx, bx
        jne     main5

mainA   call    ParGet                  ;get parameter
        jnc     main7

        mov     bp, OFFSET help
        test    flags, FSWITCH          ;check if at least one switch
        jz      main5

        call    Get_Drive               ;get drive
        mov     curdrv, al              ;save it
        mov     ax, OFFSET curdir       ;current directory
        call    Get_Directory           ;get directory

;--- separate target drive from directory

        mov     si, tardir              ;target directory
        mov     tarful, si              ;save full name
        or      si, si
        jz      mainB
        mov     ax, [si]                ;load first two bytes
        cmp     ah, ':'                 ;check if drive specified
        jne     mainB
        inc     si
        inc     si
        mov     tardir, si              ;save new start
        sub     al, 'A'                 ;convert to number
        mov     tardrv, al              ;save it

;--- set default drives

mainB   test    flags, FDRIVE           ;check if any drives specified
        jnz     mainE
        test    flags, FDELETE          ;check if clear trees
        jnz     mainD

        mov     cx, 26                  ;drive letters
        mov     di, OFFSET drives       ;start of table
        sub     si, si                  ;zero index
        mov     bx, si                  ;drive flag

mainC   call    Load_Word               ;load a word
        inc     si                      ;skip next entry
        inc     si                      ;
        neg     ax                      ;set carry if non-zero
        sbb     ax, ax                  ;set to FF if carry
        or      bx, ax                  ;set flag
        cld
        stosb                           ;set drive entry
        loop    mainC                   ;loop for each drive

        or      bx, bx                  ;check if at least one drive
        jnz     mainE
mainD   mov     al, 1                   ;default check value
        call    Reset_Drives            ;reset drives

;--- exclude drives

mainE   mov     bx, OFFSET drives       ;drive table
        mov     si, OFFSET exclude      ;exclude table
        mov     cx, 26                  ;letters
        
mainF   lodsb                           ;load exclude
        not     al                      ;toggle bits
        and     [bx], al                ;clear if excluded
        inc     bx                      ;next entry
        loop    mainF                   ;loop for all letters

;--- check commands

        test    flags, FRESCAN          ;check if rescan
        jnz     mainJ
        test    flags, FDELETE          ;check if delete
        jnz     mainK
        test    flags, FDRIVE           ;check if drive specifed
        jz      mainM
        mov     bp, OFFSET error3       ;error

;--- error

mainG   mov     ax, treseg              ;load segment
        or      ax, ax                  ;check defined
        jz      mainH
        call    MemRel                  ;release memory
mainH   mov     ax, bp                  ;error message
        or      ax, ax                  ;check if defined
        jz      mainI                   ;  skip display if not
        call    MessageL                ;display
mainI   mov     ax, 4CFFh               ;terminate
        int     21h                     ;execute

;--- rebuild trees

mainJ   call    Build_Table             ;rescan drives
        jz      mainO
        jmps    mainL

;--- delete trees

mainK   call    Delete_Table            ;delete drives
        jz      mainO

mainL   mov     bp, OFFSET error4       ;load error message
        call    Save_Table              ;save table
        jc      mainG

;--- change directory

mainM   cmp     tardir, 0               ;check if directory specified
        je      mainN
        test    flags, FNOLOAD          ;check if directory file not loaded
        jnz     mainP
        call    Change                  ;change directory
        jc      mainG

;--- normal terminate

mainN   mov     ax, treseg              ;load segment
        call    MemRel                  ;release memory
        mov     ax, 4C00h               ;terminate
        int     21h                     ;execute

;--- no changes to directory file

mainO   mov     ax, OFFSET errorA       ;message
        call    MessageF                ;display warning
        sub     bp, bp                  ;zero return message
        jmps    mainM

;--- directory file not loaded

mainP   mov     ax, OFFSET error9       ;status message
        call    MessageF                ;display warning
        sub     bp, bp                  ;zero return message
        jmps    mainG

;------------------------------------------------------------------------
; Switch handlers.

option1 mov     bp, OFFSET help
        jmps    mainG

option2 or      flags, FRESCAN
        jmp     mainA

option3 or      flags, FDELETE
        jmp     mainA

;========================================================================
; Critical error handler.

Critical PROC   FAR
        mov     al, 3                   ;fail code
        iret                            ;return
        ENDP

;========================================================================
; Reset the drive table.
;
; In: AL= reset value.

Reset_Drives PROC NEAR
        push    di
        mov     di, OFFSET drives       ;drive table
        mov     cx, 26                  ;entries
        cld
        rep
        stosb                           ;reset table
        pop     di
        ret
        ENDP

;========================================================================
; Clear tree table.

Clear_Table PROC NEAR
        push    es
        mov     es, treseg              ;load segment
        sub     ax, ax                  ;zero
        mov     di, ax                  ;
        mov     cx, BEGLEN              ;beginning length
        cld
        rep
        stosb                           ;zero table
        mov     treend, di              ;default end
        pop     es
        ret
        ENDP

;========================================================================
; Delete specified drives.

Delete_Table PROC NEAR
        push    di
        push    si
        sub     di, di                  ;zero trees deleted
        sub     si, si                  ;zero drive

deltab1 cmp     BYTE [drives + si], 0   ;check if delete
        je      deltab2
        mov     ax, si                  ;set drive
        call    Delete_Tree             ;delete tree
        jc      deltab3
        mov     ax, OFFSET status2      ;start of message
        call    MessageD                ;display message
        inc     di                      ;increment count

deltab2 inc     si                      ;next drive
        cmp     si, 26                  ;check if finished
        jne     deltab1                 ;  loop back if not

;--- finished

        or      di, di                  ;set ZF if no changes
        pop     si
        pop     di
        ret

;--- delete a drive with no tree

deltab3 cmp     BYTE [drives + si], 1   ;check if default delete
        je      deltab2
        mov     ax, OFFSET status4      ;start of message
        call    MessageD                ;display message
        jmps    deltab2
        ENDP

;========================================================================
; Build the table.
;
; Out: CY= set if invalid drive.

Build_Table PROC NEAR
        push    di
        push    si
        push    bp
        StkAll  di, MAXDIR
        sub     bp, bp                  ;zero update count

        test    flags, FDELETE          ;check if clear first
        jz      buitab1
        call    Clear_Table             ;clear table
buitab1 sub     si, si                  ;initial drive letter

buitab2 cmp     BYTE [drives + si], 0   ;check if process drive
        je      buitab3
        mov     ax, si                  ;drive to build
        call    Set_Drive               ;set drive
        jne     buitab4
        mov     ax, di                  ;directory storage
        call    Get_Directory           ;get current directory
        jc      buitab4
        mov     ax, OFFSET status1      ;start of message
        call    MessageD                ;display message
        mov     ax, si
        call    Build_Tree              ;build it
        inc     bp                      ;increment count
        mov     ax, di                  ;directory storage
        call    Set_Directory           ;restore directory

buitab3 inc     si                      ;next entry
        cmp     si, 26                  ;check if done
        jb      buitab2                 ;loop back if not
        mov     al, curdrv              ;orginal drive
        call    Set_Drive               ;restore
        clc

;--- finished

        StkRel  MAXDIR
        or      bp, bp                  ;set zero if no changes
        pop     bp
        pop     si
        pop     di
        ret

;--- unable to read drive

buitab4 cmp     BYTE [drives + si], 1   ;check if ignore error
        je      buitab3                 ;jump if so
        mov     ax, OFFSET error8       ;start of message
        call    MessageD                ;display message
        jmps    buitab3
        ENDP

;========================================================================
; Determine data file name.

Name_Table PROC NEAR
        push    di
        push    si
        push    bp
        mov     bp, OFFSET dirnam       ;place to save name

;-- check if environment variable set

        mov     si, OFFSET direnv       ;environment string

namtab1 call    EnvGet                  ;get environment string
        jc      namtab2                 ;jump if no more
        push    di
        push    si
        push    es
        mov     es, dx                  ;segment
        mov     di, ax                  ;offset
        mov     cx, 3                   ;length
        cld
        rep                             ;check if match
        cmpsb                           ;
        pop     es
        pop     si
        pop     di
        jne     namtab1                 ;loop back if not found

;--- copy name from environment

        add     ax, 3                   ;skip environment name
        mov     bx, bp                  ;save offset
        mov     cx, ds                  ;save segment
        call    StrCpyF                 ;copy
        jmps    namtab5

;--- use program name

namtab2 call    EnvPro                  ;get program name
        mov     bx, bp                  ;save offset
        mov     cx, ds                  ;save segment
        call    StrCpyF                 ;copy

;--- replace extension

        add     ax, bp                  ;point to end
        mov     bx, ax
        mov     cx, 4                   ;bytes to search for period

namtab3 dec     bx                      ;reverse
        cmp     BYTE [bx], '.'          ;check if period
        je      namtab4                 ;  exit loop if found
        loop    namtab3                 ;loop three times
        mov     bx, ax                  ;period not found, append to end

namtab4 mov     ax, OFFSET dirext       ;extension
        call    StrCpy                  ;append

namtab5 pop     bp
        pop     si
        pop     di
        ret
        ENDP

;========================================================================
; Load tree table.
;
; Out: AX= segment (0 if allocation error); CY= set if error.

Load_Table PROC NEAR
        push    bp
        mov     ax, DIRSIZ              ;max directory data size
        call    MemAll                  ;allocate memory
        jc      loatab2
        mov     bp, ax                  ;save segment

        mov     ax, OFFSET dirnam       ;file name
        mov     cl, OPEN_READ           ;open for reading
        call    FilOpn                  ;open
        jc      loatab1
        mov     bx, ax                  ;file handle
        mov     cx, DIRSIZ              ;bytes to read
        mov     dx, bp
        sub     ax, ax
        call    FilRea                  ;read block
        mov     treend, cx              ;save end
        call    FilClo                  ;close file
        clc
loatab1 mov     ax, bp                  ;return segment
        pop     bp
        ret

;--- allocation error

loatab2 sub     ax, ax                  ;zero segment
        pop     bp
        stc
        ret
        ENDP

;========================================================================
; Save tree table.
;
; Out: CY= set if error.

Save_Table PROC NEAR
        mov     ax, OFFSET status3      ;status message
        call    MessageF                ;display

        mov     ax, OFFSET dirnam       ;file name
        mov     cl, OPEN_WRITE          ;open for writing
        call    FilOpn                  ;open
        jnc     savtab1
        mov     ax, OFFSET dirnam       ;file name
        mov     cx, ATTR_NORMAL         ;normal attribute
        call    FilCre                  ;create
        jc      savtab3

savtab1 mov     bx, ax                  ;save handle
        sub     ax, ax                  ;table address
        mov     dx, treseg              ;
        mov     cx, treend              ;bytes to write
        call    FilWri                  ;write file
        sub     ax, ax                  ;dummy address
        mov     dx, treseg              ;
        sub     cx, cx                  ;zero bytes
        call    FilWri                  ;truncate file
        jc      savtab2
        call    FilClo                  ;close file
        ret

;--- error

savtab2 call    FilClo                  ;close file
savtab3 stc
        ret
        ENDP

;========================================================================
; Load tree table from tail.
;
; Out: AX= segment; CY= set if error.
;
;        push    di
;        push    si
;        push    es
;        mov     si, OFFSET tail         ;source
;        mov     es, treseg              ;target
;        sub     di, di                  ;
;        mov     cx, treend              ;bytes to copy
;        shr     cx                      ;words to copy
;        cld
;        rep
;        movsw                           ;copy tail
;        adc     cx, cx                  ;check odd byte
;        rep
;        movsb                           ;copy it
;        clc
;        pop     es
;        pop     si
;        pop     di
;        ret

;========================================================================
; Save tree table to tail.
;
; Out: CY= set if error.
;
;        push    si
;        StkAll  si, 256
;
;;--- open file
;
;        call    EnvPro                  ;get program name
;        mov     bx, si                  ;file name
;        mov     cx, ds
;        call    StrCpyF                 ;load name
;        mov     ax, OFFSET status3      ;status message
;        call    Message                 ;display it
;        mov     ax, si                  ;file name
;        call    MessageL                ;display
;        mov     ax, si                  ;file name
;        mov     cl, OPEN_WRITE          ;open for writing
;        call    FilOpn                  ;open
;        jc      savtab2
;
;;--- write table end
;
;        mov     bx, ax                  ;save handle
;        mov     cl, SEEK_FRONT          ;seek from start of file
;        mov     ax, OFFSET treend-100H  ;data location
;        sub     dx, dx                  ;
;        call    FilSee                  ;seek
;        jc      savtab1
;
;        mov     ax, OFFSET treend       ;data address
;        mov     dx, ds                  ;
;        mov     cx, 2                   ;two bytes
;        call    FilWri                  ;write
;        jc      savtab1
;
;;--- write table data
;
;        mov     cl, SEEK_FRONT          ;seek from start of file
;        mov     ax, OFFSET tail - 100H  ;data location
;        sub     dx, dx                  ;
;        call    FilSee                  ;seek
;        jc      savtab1
;
;        sub     ax, ax                  ;table address
;        mov     dx, treseg              ;
;        mov     cx, treend              ;bytes to write
;        call    FilWri                  ;write file
;        jc      savtab1
;
;        sub     cx, cx
;        call    FilWri                  ;truncate file
;
;;--- finished
;
;        call    FilClo                  ;close file
;        StkRel  256                     ;fix stack
;        pop     si
;        clc
;        ret
;
;;--- error
;
;savtab1 call    FilClo                  ;close file
;savtab2 StkRel  256                     ;fix stack
;        pop     si
;        stc
;        ret

;========================================================================
; Change directory.
;
; Out: CY= set if error; BP= error message.

Change  PROC    NEAR
        sub     bp, bp                  ;clear default error message
        mov     bx, tardir              ;target directory
        cmp     BYTE [bx], '\'          ;check direct
        je      change7

;--- find directory

        call    Tree_Check              ;check tree data
        jz      change9
        call    Tree_Start              ;start search

change1 call    Tree_Next               ;find next match
        jc      change3
        call    Check_Full              ;check if partial match
        jnz     change2                 ;  jump if so
        call    Set_Path                ;change to directory
        jc      change1
        ret

;--- found partial match

change2 mov     pardrv, al              ;save drive
        mov     ax, bx
        mov     bx, OFFSET pardir
        call    StrCpy                  ;save directory
        call    Tree_Full               ;switch to full match
        jmps    change1

;--- try changing to partial match

change3 cmp     pardrv, 0FFh            ;check if found partial match
        je      change8
        mov     al, pardrv              ;drive
        mov     bx, OFFSET pardir       ;directory
        call    Set_Path                ;change
        jnc     change6

;--- partial match failed

        call    Tree_Start              ;start search
change4 call    Tree_Next               ;skip the match that failed
        jc      change8
        call    Check_Full              ;check if full match
        jz      change4

change5 call    Tree_Next               ;find next match
        jc      change8
        call    Check_Full              ;check if full match
        jz      change5
        call    Set_Path                ;change
        jc      change5
change6 ret

;--- change to specific drive/directory

change7 mov     al, tardrv              ;drive
        mov     bx, tardir              ;directory
        call    Set_Path                ;change drive and directory
        ret

;--- directory not found

change8 mov     ax, OFFSET error5a      ;"directory"
        call    Message                 ;display
        mov     ax, tarful              ;target directory
        mov     bx, OFFSET error5b      ;"not found"
        call    MessageS                ;display
        stc
        ret

;--- no tree data

change9 mov     ax, WORD tardrv         ;load drive
        cmp     al, 0FFh                ;check if global search
        je      changeA                 ;jump if so
        push    si
        mov     si, ax
        mov     ax, OFFSET status4      ;start of message
        call    MessageD                ;display message
        pop     si
        stc
        ret

changeA mov     bp, OFFSET error7       ;no tree info saved
        stc
        ret
        ENDP

;========================================================================
; Increment a drive number.
;
; In: AL= drive letter.
;
; Out: AL= updated.

Drive_Next PROC NEAR
        inc     al                      ;increment drive
        cmp     al, 26                  ;check if okay
        jb      drinex1                 ;  jump if so
        sub     al, al                  ;wrap-around
drinex1 ret
        ENDP

;========================================================================
; Check if tree information saved.
;
; Out: ZF= set if no info.

Tree_Check PROC NEAR
        push    di
        push    si
        mov     ax, WORD tardrv         ;load target drive
        sub     dx, dx                  ;zero flag value

        sub     di, di                  ;starting drive
        mov     cx, 26                  ;drives to check
        cmp     al, 0FFh                ;check if all drives
        je      treche1                 ;  jump if so
        mov     di, ax                  ;starting drive
        mov     cx, 1                   ;drives to check

treche1 mov     ax, di                  ;set drive
        call    Tree_Address            ;get address
        or      dx, si                  ;combine
        inc     di                      ;next drive
        loop    treche1                 ;loop for each drive

        or      dx, dx                  ;set ZF
        pop     si
        pop     di
        ret
        ENDP

;========================================================================
; Switch to full matching.

Tree_Full PROC  NEAR
        inc     matlen                  ;increment length to include NUL
        inc     matnul                  ;adjust extra offset
        ret
        ENDP

;========================================================================
; Check if full match.
;
; In: DX= returned from Tree_Next.
;
; Out: ZF= 1 if full match.

Check_Full PROC NEAR
        push    bx
        mov     bx, dx                  ;end of matched directory
        sub     bx, matnul              ;include NUL offset
        cmp     BYTE [bx], 0            ;set ZF if full match
        pop     bx
        ret
        ENDP

;========================================================================
; Start a search.

Tree_Start PROC NEAR
        mov     al, tardrv              ;load target drive
        cmp     al, 0FFh                ;check if all drives
        je      tresta1                 ;  jump if so
        cmp     al, curdrv              ;check if same as current
        jne     tresta4                 ;  jump if not

tresta1 mov     al, curdrv              ;current drive
        mov     bx, OFFSET curdir       ;current directory
        call    Tree_Target             ;save target
        call    Tree_Begin              ;goto start of trees
        mov     dirlod, OFFSET Match1   ;set match routine
        call    Tree_Full               ;full match
        call    Tree_Next               ;find match
        jnc     tresta2
        call    Tree_Begin              ;start from beginning

tresta2 mov     ax, dirptr              ;point end to current directory
        mov     dirend, ax              ;

        mov     al, tardrv              ;target drive
        mov     bx, tardir              ;target directory
        call    Tree_Target             ;save target

tresta3 mov     dirlod, OFFSET Match2   ;set match routine
        ret

;--- search non-current drive

tresta4 mov     bx, tardir              ;target directory
        call    Tree_Target             ;save target drive and directory
        call    Tree_Begin              ;start from beginning
        jmps    tresta3
        ENDP

;------------------------------------------------------------------------
; Save search target.

Tree_Target PROC NEAR
        mov     matdrv, al              ;save drive
        mov     matdir, bx              ;save directory
        mov     ax, bx
        call    StrLen                  ;get length
        mov     matlen, ax              ;save it
        mov     matnul, 0               ;extra offset
        ret
        ENDP

;------------------------------------------------------------------------
; Go to beginning of directory tree.

Tree_Begin PROC NEAR
        push    si

;--- reset name variables

        sub     ax, ax                  ;zero AX (for level and drive below)
        mov     namptr, OFFSET nambuf   ;reset name pointer
        mov     namlev, ax              ;reset level

;--- find first defined tree

        cmp     matdrv, 0FFh            ;check if match drive specified
        je      trebeg1
        mov     al, matdrv              ;start with match drive
trebeg1 mov     dirdrv, al              ;save drive
        push    ax
        call    Tree_Address            ;get address
        pop     ax
        call    Drive_Next              ;increment drive
        or      si, si                  ;check if no tree
        jz      trebeg1                 ;loop back if so

;--- save start and end

        mov     dirptr, si              ;save pointer
        mov     dirend, si              ;save end
        pop     si
        ret
        ENDP

;========================================================================
; Find next matching name.
;
; Out: AL= drive; BX= directory; DX= end of directory (to check if full
;      match); CY= set if not found.
;
; Note: This routine, after getting the next path (from Tree_Name),
; checks for dirend AFTER comparing directory names.  Thus, if this
; routine is called immediately after matching the current directory
; (which is where dirend points), dirend will be skipped (possibly
; resulting in an infinite loop).  I don't think this situation will
; ever occur (it should only happen if switching to curdrv or curdir
; fails).  A better sequence would be to check for dirend BEFORE the
; compare.  However, dirend should be set to the beginning of the
; starting directory in Tree_Start (rather than the end), otherwise
; the search will fail before the current directory is reached.

Tree_Next PROC  NEAR
        push    di
        push    si
        mov     si, dirptr              ;load pointer
        jmps    trenex2

;--- check if matching directory

trenex1 call    dirlod                  ;load DI
        push    si
        mov     cx, matlen              ;load length
        mov     si, matdir              ;match directory
        cld
        rep
        cmpsb                           ;compare
        pop     si
        je      trenex6                 ;jump if found
        cmp     si, dirend              ;check if finished
        je      trenex5                 ;exit if so

;--- load next name

trenex2 call    Tree_Name               ;find next name
        jnc     trenex1                 ;next drive if none
        
;--- switch to next tree

trenex3 mov     al, dirdrv              ;load drive
        cmp     matdrv, 0FFh            ;check if match all
        jne     trenex4
        call    Drive_Next              ;increment drive
        mov     dirdrv, al              ;save drive
trenex4 call    Tree_Address            ;get address
        or      si, si                  ;check if so
        jz      trenex3                 ;loop back if so
        cmp     si, dirend              ;check if finished
        jne     trenex2                 ;loop back if okay
trenex5 stc                             ;directory not found

;--- finished

trenex6 mov     al, dirdrv              ;matched drive
        mov     bx, OFFSET nambuf       ;matched directory
        mov     dx, di                  ;end of matched directory
        mov     dirptr, si              ;save pointer
        pop     si
        pop     di
        ret
        ENDP

;------------------------------------------------------------------------
; Name match routines.

;--- compare to start of name

Match1  PROC    NEAR
        mov     di, OFFSET nambuf       ;start of complete directory
        ret
        ENDP

;--- compare last name

Match2  PROC    NEAR
        mov     di, bx                  ;start of directory name
        ret
        ENDP

;========================================================================
; Return next name in tree.
;
; In: SI= tree location.
;
; Out: SI= updated; CY= set if end of tree.

        PROC    NEAR

;--- leave a directory

trenam1 cmp     namlev, 0               ;check if at bottom
        je      trenam2
        call    Tree_Pop                ;remove last name
        dec     namlev                  ;decrement level

;--- load a command

Tree_Name LABEL NEAR                    ;entry point

trenam2 call    Load_Byte               ;load command
        cmp     al, LEAVE               ;check if leave directory
        je      trenam1
        cmp     al, FINISH              ;check if end of tree
        je      trenam3                 ;exit if so
        inc     namlev                  ;increment level
        call    Tree_Push               ;add name
        clc
        ret

;--- finished

trenam3 stc                             ;end of tree
        ret
        ENDP

;------------------------------------------------------------------------
; Add a directory name.
;
; Out: BX= start of added name.

Tree_Push PROC  NEAR
        push    di
        mov     di, namptr              ;load pointer
        push    di
        mov     al, '\'                 ;start of name
        cld
        stosb                           ;store it
        mov     dx, treseg              ;source address
        mov     ax, si                  ;
        mov     cx, ds                  ;destination address
        mov     bx, di                  ;
        call    StrCpyF                 ;copy string
        inc     ax                      ;include backslash
        add     namptr, ax              ;update name pointer
        add     si, ax                  ;update SI
        pop     bx                      ;return start of added name
        inc     bx                      ;skip backslash
        pop     di
        ret
        ENDP

;------------------------------------------------------------------------
; Remove a directory name.

Tree_Pop PROC   NEAR
        push    di
        mov     al, '\'                 ;find last backslash
        mov     cx, 0FFFFh              ;search until found
        mov     di, namptr              ;current pointer
        dec     di                      ;point to last character
        std                             ;reverse search
        repne
        scasb                           ;scan for character
        inc     di                      ;point to end
        mov     namptr, di              ;save pointer
        pop     di
        ret
        ENDP

;========================================================================
; Delete a tree.
;
; In: AL= drive letter.
;
; Out: CY= set if no tree.

Delete_Tree PROC NEAR
        push    di
        push    si
        call    Tree_Offset             ;get table offset

        push    ds
        push    es
        mov     ax, treseg              ;
        mov     ds, ax                  ;load segment
        mov     es, ax                  ;
        mov     di, [bx]                ;load start
        or      di, di                  ;check if set
        stc                             ;set carry if exit
        jz      deltre3                 ;exit if no tree

        mov     WORD [bx], 0            ;zero it
        inc     bx                      ;next entry
        inc     bx                      ;
        mov     si, [bx]                ;load end
        mov     WORD [bx], 0            ;zero it
        mov     dx, si                  ;bytes to shift
        sub     dx, di                  ;

        sub     bx, bx                  ;start of table
        mov     cx, 26 * 2              ;entries to adjust
deltre1 cmp     [bx], di                ;check need to adjust
        jbe     deltre2
        sub     [bx], dx                ;adjust
deltre2 inc     bx                      ;next entry
        inc     bx                      ;
        loop    deltre1                 ;loop for each entry

        seg     cs                      ;
        mov     cx, treend              ;bytes to shift
        sub     cx, si                  ;
        cld
        rep
        movsb                           ;delete tree

        seg     cs
        sub     treend, dx              ;adjust end (also clear CY)

deltre3 pop     es
        pop     ds
        pop     si
        pop     di
        ret
        ENDP

;========================================================================
; Build a tree.
;
; In: AL= drive letter.
;
; Out: CY= set if error.

Build_Tree PROC NEAR
        push    di
        call    Tree_Offset             ;get address
        mov     di, bx

        call    Delete_Tree             ;delete tree first
        push    treend                  ;save start of limb

        mov     ax, OFFSET root         ;root
        call    Set_Directory           ;change

        sub     ax, ax                  ;starting at root
        call    Build_Branches          ;build directories
        mov     al, FINISH              ;finished command
        call    Store_Byte              ;save it

        pop     ax                      ;start of drive
        push    es
        mov     es, treseg              ;data segment
        cld
        stosw                           ;store start
        mov     ax, treend              ;current end
        stosw                           ;store end
        pop     es
        pop     di
        ret
        ENDP

;------------------------------------------------------------------------
; Build tree branches.
;
; In: AX= branch directory (zero if root).

Build_Branches PROC NEAR
        push    si
        StkAll  si, RECSIZ              ;allocate search record
        push    ax
        or      ax, ax                  ;check if root
        jz      bldbra1
        call    Set_Directory           ;switch to directory
        push    ax
        mov     al, ENTER               ;enter command
        call    Store_Byte              ;save it
        pop     ax
        call    Store_Name              ;save name

bldbra1 mov     dx, si
        call    Find_First              ;first directory
        jc      bldbra3
bldbra2 call    Build_Branches          ;call recursively
        mov     dx, si
        call    Find_Next               ;next directory
        jnc     bldbra2                 ;loop back if found

bldbra3 pop     ax
        or      ax, ax                  ;check if root
        jz      bldbra4
        mov     ax, OFFSET parent       ;parent name
        call    Set_Directory           ;switch directory
        mov     al, LEAVE               ;leave command
        call    Store_Byte              ;save it

bldbra4 StkRel  RECSIZ                  ;fix stack
        pop     si
        ret
        ENDP

;========================================================================
; Tree address routines.

;------------------------------------------------------------------------
; Calculate tree entry offset.
;
; In: AL= drive.
;
; Out: BX= offset.

Tree_Offset PROC NEAR
        cbw                             ;expand to 16-bits
        mov     bx, ax
        add     bx, bx                  ;table offset
        add     bx, bx                  ;
        ret
        ENDP

;------------------------------------------------------------------------
; Return tree address.
;
; In: AL= drive.
;
; Out: SI= offset.

Tree_Address PROC NEAR
        call    Tree_Offset             ;get address
        mov     si, bx
        call    Load_Word               ;load word
        mov     si, ax
        ret
        ENDP

;========================================================================
; Tree load routines.

;------------------------------------------------------------------------
; Load a byte.

Load_Byte PROC  NEAR
        push    ds
        mov     ds, treseg              ;load segment
        cld
        lodsb                           ;load byte
        pop     ds
        ret
        ENDP

;------------------------------------------------------------------------
; Load a word.

Load_Word PROC  NEAR
        push    ds
        mov     ds, treseg              ;load segment
        cld
        lodsw                           ;load word
        pop     ds
        ret
        ENDP

;========================================================================
; Tree store routines.

;------------------------------------------------------------------------
; Store a byte.
;
; In: AL= byte.

Store_Byte PROC NEAR
        push    ds
        mov     bx, treend              ;load end
        mov     ds, treseg              ;load segment
        mov     [bx], al                ;store byte
        pop     ds
        inc     treend                  ;update pointer
        ret
        ENDP

;------------------------------------------------------------------------
; Store a name.
;
; In: AX= name.

Store_Name PROC NEAR
        mov     bx, treend              ;load end
        mov     cx, treseg              ;load segment
        mov     dx, ds                  ;source segment
        call    StrCpyF                 ;copy string
        inc     ax                      ;include length
        add     treend, ax              ;update pointer
        ret
        ENDP

;========================================================================
; Display message.

;------------------------------------------------------------------------
; Display a message.
;
; In: AX= message.

Message PROC    NEAR
        mov     dx, OFFSET MesPut       ;display routine

messag1 test    flags, FBANNER          ;check if banner displayed
        jnz     messag2                 ;  skip if not
        push    ax
        push    dx
        mov     ax, OFFSET banner       ;banner
        call    MesPutL                 ;show it
        or      flags, FBANNER          ;set flag
        pop     dx
        pop     ax
messag2 call    dx
        ret
        ENDP

;------------------------------------------------------------------------
; Display a message and start a new line.
;
; In: AX= message.

MessageL PROC   NEAR
        mov     dx, OFFSET MesPutL      ;display routine
        jmp     messag1                 ;branch to Message
        ENDP

;------------------------------------------------------------------------
; Display a message and a string.
;
; In: AX= message; BX= string.

MessageS PROC   NEAR
        push    bx
        call    Message                 ;display message
        pop     ax
        call    MessageL                ;display string
        ret
        ENDP

;------------------------------------------------------------------------
; Display a message and the directory file.
;
; In: AX= message.

MessageF PROC   NEAR
        mov     bx, OFFSET dirnam       ;file name
        call    MessageS                ;display
        ret
        ENDP

;------------------------------------------------------------------------
; Store a drive error message string.
;
; In: AX= message; SI= drive.

MessageStr PROC NEAR
        push    di
        mov     di, OFFSET errstr       ;save location
        push    di
        mov     bx, di
        call    StrCpy                  ;copy
        add     di, ax                  ;advance pointer
        mov     ax, si                  ;drive
        add     ax, 'A:'                ;convert to string
        cld
        stosw                           ;save them
        sub     al, al                  ;NUL
        stosb                           ;save it
        pop     ax
        pop     di
        ret
        ENDP

;------------------------------------------------------------------------
; Display a message and drive.
;
; In: AX= message; SI= drive.

MessageD PROC   NEAR
        call    MessageStr              ;create message/drive
        call    MessageL                ;display it
        ret
        ENDP

;------------------------------------------------------------------------
; Display a message, drive, and string.
;
; In: AX= message; SI= drive; BX= string.

MessageDS PROC  NEAR
        push    bx
        call    MessageStr              ;create message/drive
        call    Message                 ;display it
        pop     ax
        call    MessageL                ;display string
        ret
        ENDP

;========================================================================
; Find first and next directories.
;
; Out: AX= directory name; DX= search record; CY= set if not found.

;--- find first

Find_First PROC NEAR
        push    di
        push    si
        mov     di, dx
        call    Find_Setup              ;setup
        mov     ah, 4Eh                 ;find first
        mov     cx, 12h                 ;directories and hidden
        mov     dx, OFFSET spec         ;file specification
        int     21h                     ;execute
        jc      finfir2
        test    BYTE [si - 9], 10H      ;check if directory
        jz      finfir1
        call    Find_Skip               ;check if skip
        jnc     finfir2                 ;  jump if not
finfir1 mov     dx, di
        call    Find_Next               ;find next
finfir2 mov     ax, si
        pop     si
        pop     di
        ret
        ENDP

;--- find next

Find_Next PROC  NEAR
        push    si
        call    Find_Setup              ;setup
finnex1 mov     ah, 4Fh                 ;find next
        int     21h                     ;execute
        jc      finnex2
        test    BYTE [si - 9], 10H      ;check if directory
        jz      finnex1
        call    Find_Skip               ;check if skip
        jc      finnex1                 ;  loop back if so
finnex2 mov     ax, si
        pop     si
        ret
        ENDP

;------------------------------------------------------------------------
; Set the search record address.
;
; In: DX= search record.
;
; Out: SI= name within search record.

Find_Setup PROC NEAR
        mov     ah, 1Ah                 ;set DTA
        int     21h                     ;execute
        mov     si, dx                  ;point to name
        add     si, 30                  ;
        ret
        ENDP

;------------------------------------------------------------------------
; Check if directory name in search record should be skipped.
;
; In: SI= name.
;
; Out: CY= set if skip.

Find_Skip PROC NEAR
        mov     ax, si                  ;directory name
        mov     bx, OFFSET parent       ;double dot
        call    StrCmp                  ;check if match
        jnc     chkski1
        mov     bx, OFFSET parent + 1   ;check if single dot
        call    StrCmp                  ;check if match
chkski1 cmc                             ;set carrry if match
        ret
        ENDP

;========================================================================
; Drive and directory routines.

;------------------------------------------------------------------------
; Get current drive.
;
; In: AL= drive.
;
; Out: CY= set if error.

Get_Drive PROC  NEAR
        mov     ah, 19h                 ;get drive
        int     21h                     ;execute
        ret
        ENDP

;------------------------------------------------------------------------
; Set current drive.
;
; In: AL= drive.
;
; Out: CY= set if error.

Set_Drive PROC  NEAR
        push    ax
        mov     dl, al                  ;drive number
        mov     ah, 0Eh                 ;set drive
        int     21h                     ;execute
        call    Get_Drive               ;get drive
        cmp     al, dl                  ;set ZF
        pop     ax
        ret
        ENDP

;------------------------------------------------------------------------
; Get current directory.
;
; In: AX= directory area.
;
; Out: CY= set if error.

Get_Directory PROC NEAR
        push    si
        mov     si, ax                  ;save location
        mov     BYTE [si], '\'          ;save starting \
        inc     si                      ;skip it
        mov     ah, 47h                 ;get directory
        sub     dl, dl                  ;default drive
        int     21h                     ;execute
        pop     si
        ret
        ENDP

;------------------------------------------------------------------------
; Set current directory.
;
; In: AX= directory name.
;
; Out: CY= set if error.

Set_Directory PROC NEAR
        push    ax
        mov     dx, ax                  ;directory name
        mov     ah, 3Bh                 ;set directory
        int     21h                     ;execute
        pop     ax
        ret
        ENDP

;------------------------------------------------------------------------
; Change to a drive and directory.
;
; In: AL= drive; BX= directory.

Set_Path PROC   NEAR
        push    di
        push    si
        cbw                             ;zero high byte
        mov     si, ax                  ;save drive
        mov     di, bx                  ;save directory

;--- set drive

        cmp     al, 0FFh                ;check if skip
        je      setpat1
        call    Set_Drive               ;set the drive
        jc      setpat2

;--- set directory

setpat1 mov     ax, di
        call    Set_Directory           ;set directory
        jnc     setpat3

;--- could not change to path

setpat2 mov     ax, OFFSET error6       ;error message
        mov     bx, di                  ;string to display
        call    MessageDS               ;display

;--- restore original

        mov     al, curdrv              ;original drive
        call    Set_Drive               ;set the drive
        mov     ax, OFFSET curdir       ;original directory
        call    Set_Directory           ;set directory
        stc                             ;error

;--- finished

setpat3 pop     si
        pop     di
        ret
        ENDP

;========================================================================
; Data.

;--- flags

FSWITCH EQU     01h                     ;switch specified
FRESCAN EQU     02h                     ;rescan selected drives
FDELETE EQU     04h                     ;delete selected drives
FDRIVE  EQU     08h                     ;drive specified
FBANNER EQU     10h                     ;banner has been displayed
FNOLOAD EQU     20h                     ;table not loaded

flags   DB      0                       ;flags

;------------------------------------------------------------------------
; Initialized data.

tardrv  DB      0FFh                    ;target drive (default match any)
        DB      0                       ; zeroed high byte
tardir  DW      0                       ;target directory
treseg  DW      0                       ;tree segment
treend  DW      BEGLEN                  ;tree end
pardrv  DB      0FFh                    ;partial match (FF if none)

direnv  DB      'SD=',0                 ;environment string
dirext  DB      '.DIR',0                ;directory extension

spec    DB      '*.*',0                 ;file specification
parent  DB      '..',0                  ;parent directory
root    DB      '\',0                   ;root directory

switch1 DB      '?',0
switch2 DB      '/?',0
switch3 DB      '/R',0
switch4 DB      '/REFRESH',0
switch5 DB      '/F',0
switch6 DB      '/FORGET',0
switch7 DB      '/C',0
switch8 DB      '/CLEAR',0

error1  DB      'Not enough memory',0
error2  DB      'Invalid drive letter',0
error3  DB      'Error in switches',0
error4  DB      'Error saving file',0
error5a DB      'Directory "',0
error5b DB      '" not found',0
error6  DB      'Error changing to ',0
error7  DB      'No tree data saved',0
error8  DB      'Error reading drive ',0
error9  DB      'Unable to load file ',0
errorA  DB      'No changes to file ',0

status1 DB      'Reading tree from drive ',0
status2 DB      'Removing tree data for drive ',0
status3 DB      'Updating file ',0
status4 DB      'No tree data for drive ',0

banner LABEL BYTE
 DB 13,10
 DB 'Speed Directory  Version 2.01  Eric Tauck',13,10
 DB 0

help LABEL BYTE
 DB 'Usage:',13,10
 DB 13,10
 DB '   SD [<drive>]<directory>                  change directory',13,10
 DB '   SD [[+|-]<drive> ...] /REFRESH [/CLEAR]  refresh directory tree(s)',13,10
 DB '   SD [[+|-]<drive> ...] /FORGET            forget directory tree(s)'
 DB 0

;--- switch table

table   LABEL   WORD
        DW      OFFSET switch1, OFFSET option1
        DW      OFFSET switch2, OFFSET option1
        DW      OFFSET switch3, OFFSET option2
        DW      OFFSET switch4, OFFSET option2
        DW      OFFSET switch5, OFFSET option3
        DW      OFFSET switch6, OFFSET option3
        DW      OFFSET switch7, OFFSET option3
        DW      OFFSET switch8, OFFSET option3
OPTEND  EQU     $

;------------------------------------------------------------------------
; Start of directory tail.
;
;        DS      $ AND 1                 ;set to even address
;tail    LABEL   BYTE                    ;start of tail

;------------------------------------------------------------------------
; Uninitialized data.

tarful  LABEL   WORD                    ;full target name
        ORG     +2
dirnam  LABEL   BYTE                    ;directory file name
        ORG     +256
errstr  LABEL   BYTE                    ;error string
        ORG     +256
pardir  LABEL   BYTE                    ;partial match directory
        ORG     +256

;--- current path

curdrv  LABEL   BYTE                    ;current drive
        ORG     +1
curdir  LABEL   BYTE                    ;current directory
        ORG     +256

;--- drive table

drives  LABEL   BYTE                    ;drive table
        ORG     +26
exclude LABEL   BYTE                    ;excluded drive table
        ORG     +26

;--- change directory data

namptr  LABEL   WORD                    ;name pointer
        ORG     +2
nambuf  LABEL   BYTE                    ;name buffer
        ORG     +256
namlev  LABEL   WORD                    ;directory level
        ORG     +2

matdrv  LABEL   BYTE                    ;target drive
        ORG     +1
matdir  LABEL   WORD                    ;target directory
        ORG     +2
matlen  LABEL   WORD                    ;target length
        ORG     +2
matnul  LABEL   WORD                    ;extra offset to NUL
        ORG     +2

dirdrv  LABEL   BYTE                    ;current tree drive
        ORG     +1
dirptr  LABEL   WORD                    ;tree table pointer
        ORG     +2
dirend  LABEL   WORD                    ;tree table wrap end
        ORG     +2
dirlod  LABEL   WORD                    ;compare load routine
        ORG     +2

        ORG     +16000                  ;extra stack

;------------------------------------------------------------------------
; Default directory tail.
;
;        DS      BEGLEN, 0
