/////////////////////////
// Trailer Definitions //
/////////////////////////

#pragma once

const int HEAD = 0x44414548;
const int TAIL = 0x4C494154;

struct Trailer
{
    int Head;
    unsigned FilesOffset;
    unsigned FilesSize;
    unsigned DataOffset;
    unsigned DataSize;
    int Tail;
};


// commands

const int COMMAND_CNT = 14;

const int CMD_NONE = 0;
const int CMD_EXECUTE = 1;      // run program
const int CMD_DELETE = 2;       // delete file
const int CMD_INSTALL = 3;      // expand, don't replace
const int CMD_REPLACE = 4;      // expand, replace
const int CMD_COPY = 5;         // not used
const int CMD_RENAME = 6;       // rename file
const int CMD_MKDIR = 7;        // not used
const int CMD_RMDIR = 8;        // not used
const int CMD_MENU = 9;         // start menu link
const int CMD_DESK = 10;        // desktop link
const int CMD_TARGET = 11;      // setup file target name
const int CMD_TITLE = 12;       // install title
const int CMD_HOME = 13;        // install home directory

extern const unsigned COMMAND_ARGS [COMMAND_CNT];   // number install arguments -- NOT script arguments