//////////////////
// Parser Class //
//////////////////

#include "Parser.h"
#include "Trailer.h"
#include <string.h>

const char *WHITESPACE = " =";
const char QUOTE = '"';
const char COMMENT = ';';

static const char * Commands [COMMAND_CNT] =
{
    "",
    "EXECUTE",
    "DELETE",
    "INSTALL",
    "REPLACE",
    "COPY",
    "RENAME",
    "MKDIR",
    "RMDIR",
    "MENU",
    "DESK",
    "TARGET",
    "TITLE",
    "HOME"
};

static const int IsSpace (char chr)
{
    return chr && ((chr < ' ') || strchr (WHITESPACE, chr));
}

static char * SkipSpace (char *ptr)
{
    while (IsSpace (*ptr))
        ptr ++;

    return ptr;
}

static char * GetField (char *ptr, char **start)
{
    char *end;
    int quote;

    ptr = SkipSpace (ptr);

    if (*ptr == QUOTE) {
        ptr ++;
        quote = 1;
    } else {
        quote = 0;
        if (*ptr == COMMENT)
            *ptr = NULL;
    }

    *start = ptr;

    if (!*ptr)
        return NULL;

    end = NULL;

    while (!end)
        if (*ptr) {
            if ((quote && (*ptr == QUOTE)) || (!quote && (IsSpace (*ptr))))
                end = ptr;
            ptr ++;
        } else
            end = ptr;

    *end = NULL;

    return ptr;
}

Parser::Parser (int max)
{
    _Buffer = new char [max];
}

Parser::~Parser ()
{
    delete _Buffer;
}

void Parser::Parse (const char *line)
{
    int fields;
    char *ptr;

    strcpy (_Buffer, line);
    ptr = _Buffer;
    fields = 0;

    while (ptr)
        ptr = GetField (ptr, &_Arguments [fields ++]);

    for (int i = fields; i < MAXFIELDS; i ++)
        _Arguments [i] = _Arguments [fields - 1];

    _Command = 1;

    while (stricmp (_Arguments [0], Commands [_Command])) {
        _Command ++;
        if (_Command == COMMAND_CNT) {
            _Command = CMD_NONE;
            break;
        }
    }
}