//////////////////////
// Compile Function //
//////////////////////

#include "Parser.h"
#include "Trailer.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <epp.h>

const int BUFFERSIZE = 0x8000;

const char *TEMP1 = "PRESTALL.1";
const char *TEMP2 = "PRESTALL.2";
const char *TEMP3 = "PRESTALL.XXX";

static class Merge
{
    public:

        Merge ();
        ~Merge ();

        void Create (const char *);
        void Close ();

        int Append (const char *name);
        void Append (const char *data, unsigned bytes);

    private:

        FILE *_File;
        char *_Buffer;
};

Merge::Merge ()
{
    _Buffer = new char [BUFFERSIZE];
    _File = NULL;
}

Merge::~Merge ()
{
    Close ();
    delete _Buffer;
}

void Merge::Create (const char *name)
{
    _File = fopen (name, "w+b");
}

void Merge::Close ()
{
    if (_File) {
        fclose (_File);
        _File = NULL;
    }
}

int Merge::Append (const char *name)
{
    FILE *file;
    int bytes, total;

    total = 0;
    file = fopen (name, "rb");
    if (file) {
        do {
            bytes = fread (_Buffer, 1, BUFFERSIZE, file);
            fwrite (_Buffer, 1, bytes, _File);
            total += bytes;
        } while (bytes > 0);
        fclose (file);
    }

    return total;
}

void Merge::Append (const char *data, unsigned bytes)
{
    fwrite (data, 1, bytes, _File);
}

static class Script
{
    public:

        Script ();
        ~Script ();

        void Append (int number);
        void Append (const char *string);

        operator void * ();
        operator unsigned ();

    private:

        char *_Buffer;
        unsigned _Bytes;
};

inline Script::operator void * ()
    { return _Buffer; }

inline Script::operator unsigned ()
    { return _Bytes; }

Script::Script ()
{
    _Buffer = new char [BUFFERSIZE];
    _Bytes = 0;
}

Script::~Script ()
{
    delete _Buffer;
}

void Script::Append (int number)
{
    char temp [32];

    Append (_itoa (number, temp, 10));
}

void Script::Append (const char *string)
{
    int len;

    len = strlen (string) + 1;
    memcpy (_Buffer + _Bytes, string, len);
    _Bytes += len;
}

void Compile (const char *source, const char *stub)
{
    Parser parser (512);
    Merge merge;
    Script script;
    Trailer trailer;
    FILE *file;
    char line [512];
    char title [256];
    char home [256];
    char save [256];
    unsigned size;
    unsigned offset;
    int cmd, i;

    // process file file

    title [0] = NULL;
    home [0] = NULL;
    save [0] = NULL;

    file = fopen (source, "r");
    merge.Create (TEMP1);

    while (fgets (line, sizeof (line), file)) {
        parser.Parse (line);

        cmd = parser.Command ();

        switch (cmd) {
            case CMD_TITLE:
                strcpy (title, parser.Argument (1));
                break;
            case CMD_HOME:
                strcpy (home, parser.Argument (1));
                break;
            case CMD_TARGET:
                strcpy (save, parser.Argument (1));
                break;
            case CMD_INSTALL:
            case CMD_REPLACE:
                size = merge.Append (parser.Argument (1));
                script.Append (cmd);
                if (strlen (parser.Argument (2)))
                    script.Append (parser.Argument (2));
                else
                    script.Append (parser.Argument (1));
                script.Append (size);
                break;
            case CMD_EXECUTE:
            case CMD_DELETE:
            case CMD_MKDIR:
            case CMD_RMDIR:
                script.Append (cmd);
                script.Append (parser.Argument (1));
                break;
            case CMD_MENU:
            case CMD_DESK:
            case CMD_COPY:
            case CMD_RENAME:
                script.Append (cmd);
                script.Append (parser.Argument (1));
                script.Append (parser.Argument (2));
                break;
       }
    }
    script.Append ("");
    fclose (file);
    merge.Close ();

    // compress combined files

    epp_Process compress;
    wsprintf (line, "COMPRESS %s %s", TEMP1, TEMP2);
    compress.Create (line, NULL);
    WaitForSingleObject (compress, INFINITE);

    // merge files

    merge.Create (TEMP3);

    size = merge.Append (stub);
    trailer.FilesOffset = size;
    size = merge.Append (TEMP2);
    trailer.FilesSize = size;
    trailer.DataOffset = trailer.FilesOffset + trailer.FilesSize;

    size = strlen (title) + 1;
    merge.Append (title, size);
    trailer.DataSize = size;
    size = strlen (home) + 1;
    merge.Append (home, size);
    trailer.DataSize += size;
    size = script;
    merge.Append (script, size);
    trailer.DataSize += size;

    trailer.Head = HEAD;
    trailer.Tail = TAIL;

    merge.Append ((void *) &trailer, sizeof (trailer));
    merge.Close ();

    remove (TEMP1);
    remove (TEMP2);

    if (strlen (save)) {
        remove (save);
        rename (TEMP3, save);
    }
}