///////////////////
// Toolbar Class //
///////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "toolbar.epp"

HWND epp_ToolBar::Create (HWND owner, DWORD style, UINT id, const int *panes, const int *commands, int count)
{
	TBBUTTON *data;
	HWND ret;

	data = new TBBUTTON [count];
	memset (data, 0, count * sizeof (TBBUTTON));

	for (int i = 0; i < count; i++) {
		data [i].idCommand = commands [i];
		data [i].fsState = TBSTATE_ENABLED;
		if (commands [i]) {
			data [i].iBitmap = panes [i];
			data [i].fsStyle = TBSTYLE_BUTTON;
		} else {
			data [i].iBitmap = 0;
			data [i].fsStyle = TBSTYLE_SEP;
		}
	}

	ret = CreateToolbarEx (owner, style | WS_CHILD, 0, count, (id)? EPP_INSTANCE : HINST_COMMCTRL, id, data, count, 0, 0, 0, 0, sizeof (TBBUTTON));
	delete data;
	return ret;
}