/////////////////
// Frame Class //
/////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "class.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"
#include "handler.epp"
#include "frame.epp"

static int FrameCount = 0;

void epp_Frame::OnNotify (int, NMHDR *header)
{
    if (header->code == TTN_NEEDTEXT) {
        TOOLTIPTEXT *tooltip = (TOOLTIPTEXT *) header;
        tooltip->lpszText = MAKEINTRESOURCE (header->idFrom);
        tooltip->hinst = EPP_INSTANCE;
    } else
        Forward ();
}

LRESULT epp_Frame::OnNcCreate (CREATESTRUCT *)
  {
  FrameCount ++;
  return Forward ();
  }

void epp_Frame::OnNcDestroy ()
  {
  if (--FrameCount == 0)
    PostQuitMessage (0);

  Forward ();
  }

BEGIN_HANDLER (epp_Frame, epp_Window)
  ON_WM_NOTIFY
  ON_WM_NCCREATE
  ON_WM_NCDESTROY
END_HANDLER