////////////////////
// Common Dialogs //
////////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "handler.epp"
#include "dialog.epp"
#include "dialogc.epp"
#include <string.h>

BOOL epp_FileDialog::Create (DWORD flags, int tempid, const TCHAR *title, const TCHAR *deffile, const TCHAR *directory, const TCHAR *defext, const TCHAR *filter, int findex, HWND parent)
{
    BOOL ret;

    if (deffile)
        strcpy (_File, deffile);
    else
        _File [0] = NULL;

    memset (&_Open, 0, sizeof (_Open));

    _Open.lStructSize = sizeof (_Open);
    _Open.hwndOwner = parent;
    _Open.hInstance = EPP_INSTANCE;
    _Open.lpstrFilter = filter;
    _Open.nFilterIndex = findex;
    _Open.lpstrFile = _File;
    _Open.nMaxFile = sizeof (_File);
    _Open.lpstrInitialDir = directory;
    _Open.lpstrTitle = title;
    _Open.Flags = flags;
    _Open.lpstrDefExt = defext;
    _Open.lpTemplateName = MAKEINTRESOURCE (tempid);

    return _Create (&_Open);
}