//////////////////
// Dialog Class //
//////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "handler.epp"
#include "dialog.epp"

void epp_Dialog::Destroy ()
  {
  EndDialog ();
  }

void epp_Dialog::OnOkay ()
{
}

inline BOOL epp_Dialog::EndDialog (int result)
  {
  HWND temp;
  temp = _Handle;
  _Handle = NULL;
  return ::EndDialog (temp, result);
  }

LRESULT epp_Dialog::System ()
  {
  return FALSE;
  }


void epp_Dialog::OnCommand (int, int id, HWND)
  {
  switch (id)
    {
    case IDOK:
      _Okay = TRUE;
      OnOkay ();
      Close ();
      break;
    case IDCANCEL:
      _Okay = FALSE;
      Close ();
      break;
    }
  }

void epp_Dialog::OnHelp (HELPINFO *info)
  {
  HWND handle;

  if (info->iContextType == HELPINFO_WINDOW)
    handle = info->hItemHandle;
  else
    handle = *this;

  ::WinHelp (handle, EPP_HELPFILE, HELP_CONTEXTPOPUP, info->dwContextId);
  }

int epp_Dialog::OnInitDialog (HWND, LPARAM)
  {
  return TRUE;
  }

BEGIN_HANDLER (epp_Dialog, epp_Window)
  ON_WM_HELP
  ON_WM_COMMAND
  ON_WM_INITDIALOG
END_HANDLER