///////////////////
// Animate Class //
///////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "class.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"
#include "handler.epp"
#include "frame.epp"
#include "timer.epp"
#include "object.epp"
#include "bitmap.epp"
#include "context.epp"
#include "animate.epp"

HWND epp_Animate::Create (int bitmap, int frames, int timer, DWORD style, RECT& rect, HWND parent)
{
    epp_WindowContext temp;

    _Frames = frames;
    _Frame = 0;
    _Ticker = timer;
    _Width = rect.right - rect.left;
    _Height = rect.bottom - rect.top;
    _Bitmap.LoadBitmap (bitmap);

    temp.GetDC (parent);
    _Source.CreateCompatibleDC (temp);
    _Source.SelectObject (_Bitmap);
    temp.Close ();

    return epp_Frame::Create (0, NULL, style | WS_CHILD , rect, parent);
}