///////////////////
// Animate Class //
///////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "class.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"
#include "handler.epp"
#include "frame.epp"
#include "timer.epp"
#include "object.epp"
#include "bitmap.epp"
#include "context.epp"
#include "animate.epp"

void epp_Animate::_DrawFrame (HDC target)
{
    ::BitBlt (target, 0, 0, _Width, _Height, _Source, _Frame * _Width, 0, SRCCOPY);
}

int epp_Animate::OnCreate (CREATESTRUCT *)
{
    _Timer.Create (_Ticker, *this);
    return 0;
}

void epp_Animate::OnDestroy ()
{
    _Timer.Close ();
    _Bitmap.Close ();
    _Source.Close ();
}

BOOL epp_Animate::OnEraseBkgnd (HDC)
{
    return TRUE;
}

void epp_Animate::OnPaint ()
{
    epp_PaintContext dc;

    dc.BeginPaint (*this);
    _DrawFrame (dc);
}

void epp_Animate::OnTimer (int)
{
    epp_WindowContext target;

    target.GetDC (*this);
    _DrawFrame (target);
    ValidateRect ();

    _Frame = ++_Frame % _Frames;
}

BEGIN_HANDLER (epp_Animate, epp_Frame)
    ON_WM_TIMER
    ON_WM_PAINT
    ON_WM_ERASEBKGND
    ON_WM_CREATE
    ON_WM_DESTROY
END_HANDLER