//////////////////////
// Listbox Subclass //
//////////////////////

#pragma once

#include "View Item.h"

class ContextMenu
{
    public:

        virtual HMENU GetContextMenu () = 0;
};

class SubList : public epp_Subclass
{
    public:

        void Create (HWND, ContextMenu *, ViewItem *);

    protected:

        epp_ListBox ListBox;

    private:

        void OnLButtonDown (int, int, int);
        void OnLButtonUp (int, int, int);
        void OnMouseMove (int, int, int);
        void OnRButtonDown (int, int, int);

        ContextMenu *Menu;
        ViewItem *View;
        int Ticker;

    DECLARE_HANDLER
};

class SubNoErase : public epp_Subclass
{
    public:

        void Create (epp_ListBox&);

    private:

        BOOL OnEraseBkgnd (HDC);
        void OnSize (int, int, int);

        epp_ListBox ListBox;
        RECT Area;

    DECLARE_HANDLER
};