//////////////////////
// Listbox Subclass //
//////////////////////

#include "Subclass.h"

static const int Edge = GetSystemMetrics (SM_CXVSCROLL);

void SubList::Create (HWND listbox, ContextMenu *menu, ViewItem* view)
{
    Menu = menu;
    View = view;
    ListBox.Attach (listbox);
    epp_Subclass::Create (listbox);
}

void SubList::OnLButtonDown (int, int, int)
{
    Ticker = 0;
    Forward ();
}

void SubList::OnLButtonUp (int, int, int)
{
    Ticker = 0;
    Forward ();
}

void SubList::OnMouseMove (int keys, int, int)
{
    if (View && (keys & MK_LBUTTON) && (++Ticker == 2))
        View->StartDrag (*this);

    Forward ();
}

void SubList::OnRButtonDown (int, int x, int y)
{
    epp_Menu menu;
    HMENU hmenu;
    RECT rect;
    int index;

    GetClientRect (&rect);
    if ((x < (rect.right - Edge)) && ListBox.GetCount ()) {
        ListBox.SetCurSel (ListBox.GetTopIndex () + (y / LINEHEIGHT));
        if (Menu) {
            hmenu = Menu->GetContextMenu ();
            if (hmenu) {
                menu.Attach (hmenu);
                POINT point = {x, y};
                ClientToScreen (&point);
                menu.TrackPopupMenu (0, point.x, point.y, GetParent (), NULL, 0);
            }
        }
    }

    Forward ();
}

BEGIN_HANDLER (SubList, epp_Subclass)
    ON_WM_MOUSEMOVE
    ON_WM_LBUTTONDOWN
    ON_WM_LBUTTONUP
    ON_WM_RBUTTONDOWN
END_HANDLER

// limited erase subclass

void SubNoErase::Create (epp_ListBox& listbox)
{
    RECT rect;

    ListBox.Attach (listbox);
    ListBox.GetClientRect (&Area);
    epp_Subclass::Create (listbox);
}

BOOL SubNoErase::OnEraseBkgnd (HDC hdc)
{
    static epp_Brush Back;
    int total, top;

    total = ListBox.GetCount ();

    if (total == 0)
        top = 0;
    else
        top = ListBox.GetTopIndex ();

    Area.top = (total - top) * LINEHEIGHT;

    if (Area.top <= Area.bottom) {
        epp_Context dc;
        dc.Attach (hdc);
        if (!Back)
            Back.CreateSolidBrush (GetSysColor (COLOR_WINDOW));
        dc.FillRect (&Area, Back);
    }

    return TRUE;
}

void SubNoErase::OnSize (int, int, int)
{
    GetClientRect (&Area);
    Forward ();
}

BEGIN_HANDLER (SubNoErase, epp_Subclass)
    ON_WM_ERASEBKGND
    ON_WM_SIZE
END_HANDLER