////////////////////
// Master Library //
////////////////////

#pragma once

#include "Card List.h"

class LibraryClass
{
	public:

        LibraryClass ();

        void Load ();
		void Save ();
        void Import (epp_ListBox&, epp_ListBox&, const char *);
		int New (CARD_INFO& card);
        int Find (const char *name);
		void Find (int key, CARD_INFO& card);
		void Update (CARD_INFO& card);
		void Delete (int key);
		void FindCards (epp_ListBox& target, const CARD_SEARCH * = NULL);
		void FindCards (epp_ListBox& source, epp_ListBox& target, const CARD_SEARCH * = NULL);
		BOOL Loaded ();

	private:

        int _Find (const char *name);
		int _Find (int key);

	    epp_Array <CARD_INFO> _Data;
	    int _Cards;

        BOOL _Loaded;
	    BOOL _Flush;
	    BOOL _Changed;
};

inline BOOL LibraryClass::Loaded ()
    { return _Loaded; }

extern LibraryClass Library;

// global functions

const char * SearchTitle (const CARD_SEARCH *);
void SearchLibrary (CardList *source, CardList *target, const CARD_SEARCH *);