////////////////////////
// Global Definitions //
////////////////////////

#pragma once

#include "version.h"
#include "resource.k"
#include <epp.h>

const char DELIM = '\xFE';

const int SIGNATURE = 0x44580002;
const int SAVED_CARD = 1;
const int SAVED_DECK = 2;

static const int ANIMATEX = 32;
static const int ANIMATEY = 32;
static const int ANIFRAMES = 34;
static const int ANISPEED = 70;

const int ITEM_CLOSE = WM_USER + 0;

enum SORT
{
    SORT_NAME,
    SORT_TYPE
};

// screen element sizes

const int EXTRA = 2;            // space between lines
const int BASE = 16;            // basic line height
const int MAXCAST = 7;          // maximum casting characters

const int WIDTH1 = 200;         // name and type width
const int WIDTH2 = 30;          // power and toughness width
const int WIDTH3 = 10;          // power/toughness '/' width
const int MAXABILITIES = 7;     // maximum different abilites

const int WIDTHX = WIDTH1 + ((MAXCAST + 1) * BASE);

const int LINEWIDTH = (BASE / 2) + ((MAXCAST + 1) * BASE) + WIDTH1 + WIDTH1 + WIDTH2 + WIDTH3 + WIDTH2 + (MAXABILITIES * BASE);
const int LINEHEIGHT = BASE + EXTRA;

// card flag values

const int PROTECTION =  0x00000001;
const int REGENERATE =  0x00000002;
const int FLYING =      0x00000004;
const int LANDWALK =    0x00000008;
const int BANDING =     0x00000010;
const int FIRSTSTRIKE = 0x00000020;
const int TRAMPLE =     0x00000040;
const int RAMPAGE =     0x00000080;
const int UPKEEP =      0x00000100;
const int CUMULATIVE =  0x00000200;
const int SUMMON =      0x00000400;
const int ENCHANTMENT = 0x00000800;
const int SORCERY =     0x00001000;
const int INSTANT =     0x00002000;
const int INTERRUPT =   0x00004000;
const int ARTIFACT =    0x00008000;
const int LAND =        0x00010000;
const int CREATURE =    0x00020000;
const int PERMANENT =   0x00040000;
const int FASTEFFECT =  0x00080000;
const int RED =         0x00100000;
const int GREEN =       0x00200000;
const int WHITE =       0x00400000;
const int BLACK =       0x00800000;
const int BLUE =        0x01000000;
const int COLORLESS =   0x02000000;
const int MULTICOLOR =  0x04000000;
const int PHASING =     0x08000000;
const int FLANKING =    0x10000000;
const int MANASOURCE =  0x20000000;

const int FLAGS_COLORS =      RED | GREEN | WHITE | BLACK | BLUE | COLORLESS | MULTICOLOR;
const int FLAGS_TYPE =        SUMMON | ENCHANTMENT | SORCERY | INSTANT | INTERRUPT | MANASOURCE | ARTIFACT | LAND | CREATURE | PERMANENT | FASTEFFECT;
const int FLAGS_ABILITIES =   PHASING | PROTECTION | REGENERATE | FLYING | LANDWALK | BANDING | FLANKING | FIRSTSTRIKE | TRAMPLE | RAMPAGE | UPKEEP | CUMULATIVE;

// edition / expansion flags

const int ED_UL =       0x00000001;     // unlimited
const int ED_RV =       0x00000002;     // revised
const int ED_4E =       0x00000004;     // 4th edition
const int ED_AI =       0x00000008;     // alliances
const int ED_AN =       0x00000010;     // arabian nights
const int ED_AQ =       0x00000020;     // antiquities
const int ED_CH =       0x00000040;     // chronicles
const int ED_DK =       0x00000080;     // the dark
const int ED_FE =       0x00000100;     // fallen empires
const int ED_HL =       0x00000200;     // homelands
const int ED_IA =       0x00000400;     // ice age
const int ED_LG =       0x00000800;     // legends
const int ED_MI =       0x00001000;     // mirage
const int ED_P  =       0x00002000;     // promotional
const int ED_VI =       0x00004000;     // visions
const int ED_5E =       0x00008000;     // 5th edition
const int ED_WL =       0x00010000;     // weatherlight
const int ED_TE =       0x00020000;     // tempest

const int KEYMASK =     0x0000FFFF;
const int KEYINCR =     0x00010000;

struct CARD_INFO
{
	int Key;
	char Name [50];
	char Type [50];
	char Cast [10];
	char Power [10];
	char Tough [10];
	char Spec [100];
	char Desc [1500];
	char Freq [20];
	int Deleted;
	int Abilities;
	int Edition;
};

// search record

struct CARD_SEARCH
{
    char Name [256];
    char Type [256];
    char Spec [256];
    char Desc [256];
    BOOL NameAnywhere;
    BOOL TypeAnywhere;
    BOOL SkipMatch;
    int SetFlags;
    int ClearFlags;
    int SetEdition;
    int ClearEdition;
};