////////////////////
// Import Classes //
////////////////////

#pragma once

#include "global.h"
#include <iostream.h>

class Line
{
    public:

        Line ();
        ~Line ();

        BOOL Load (istream&);
        void Finished ();
        int Indent ();

        void SkipSpace ();
        void SkipColumns (int);
        void ReadColumns (char *, int);
        void ReadToChar (char *, char);
        void ReadToEnd (char *);

    private:

        char *_Line;
        BOOL _Loaded;
        int _Indent;
        int _Index;
};

inline int Line::Indent ()
    { return _Indent; }

class DevjoeFilter
{
    public:

        DevjoeFilter ();
        ~DevjoeFilter ();

        BOOL Read (istream& stream, CARD_INFO& card);

    private:

        Line _Line;
        char *_Desc;
};


class ListFilter
{
    public:

        void ReadHeader (istream& stream, char *title);
        BOOL Read (istream& stream, int& count, char *card);
        void WriteHeader (ostream& stream, const char *title);
        void Write (ostream& stream, int count, const char *card);

    private:

        Line _Line;
};