///////////////////////
// Drawing Functions //
///////////////////////

#include "Drawing.h"
#include <stdio.h>
#include <string.h>

BOOL Nice = FALSE;

// mana symbols

epp_CustomContext Scratch;

epp_Bitmap ManaMask;
epp_Bitmap RedMana;
epp_Bitmap GreenMana;
epp_Bitmap WhiteMana;
epp_Bitmap BlackMana;
epp_Bitmap BlueMana;
epp_Bitmap ZeroMana;
epp_Bitmap OneMana;
epp_Bitmap TwoMana;
epp_Bitmap ThreeMana;
epp_Bitmap FourMana;
epp_Bitmap FiveMana;
epp_Bitmap SixMana;
epp_Bitmap SevenMana;
epp_Bitmap EightMana;
epp_Bitmap NineMana;
epp_Bitmap XMana;
epp_Bitmap Tap;

static BOOL ValidMana (char m)
{
    return (BOOL) strchr ("RGWBU0123456789XT", m);
}

static int ManaWidth (const char *mana)
{
    int width;

    width = 0;

    while (*mana) {
        if (ValidMana (*mana))
            width += BASE;
        mana ++;
    }

    return width;
}

static void DrawBitmap (epp_Context& target, const RECT& rect, epp_Bitmap& mana)
{
    Scratch.SelectObject (ManaMask);
    target.BitBlt (rect.left, rect.top, BASE, BASE, Scratch, 0, 0, SRCAND);
    Scratch.SelectObject (mana);
    target.BitBlt (rect.left, rect.top, BASE, BASE, Scratch, 0, 0, SRCPAINT);
}

static int DrawMana (epp_Context& target, const RECT& start, const char *mana)
{
    RECT rect;
    int length;

    if (!Scratch) {
        Scratch.CreateCompatibleDC (target);
        ManaMask.LoadBitmap (IDB_MASKMANA);

        if (Nice) {
            RedMana.LoadBitmap (IDB_REDMANA);
            GreenMana.LoadBitmap (IDB_GREENMANA);
            WhiteMana.LoadBitmap (IDB_WHITEMANA);
            BlackMana.LoadBitmap (IDB_BLACKMANA);
            BlueMana.LoadBitmap (IDB_BLUEMANA);
            ZeroMana.LoadBitmap (IDB_ZEROMANA);
            OneMana.LoadBitmap (IDB_ONEMANA);
            TwoMana.LoadBitmap (IDB_TWOMANA);
            ThreeMana.LoadBitmap (IDB_THREEMANA);
            FourMana.LoadBitmap (IDB_FOURMANA);
            FiveMana.LoadBitmap (IDB_FIVEMANA);
            SixMana.LoadBitmap (IDB_SIXMANA);
            SevenMana.LoadBitmap (IDB_SEVENMANA);
            EightMana.LoadBitmap (IDB_EIGHTMANA);
            NineMana.LoadBitmap (IDB_NINEMANA);
            XMana.LoadBitmap (IDB_XMANA);
            Tap.LoadBitmap (IDB_TAP);
        } else {
            RedMana.LoadBitmap (IDB_REDMANA2);
            GreenMana.LoadBitmap (IDB_GREENMANA2);
            WhiteMana.LoadBitmap (IDB_WHITEMANA2);
            BlackMana.LoadBitmap (IDB_BLACKMANA2);
            BlueMana.LoadBitmap (IDB_BLUEMANA2);
            ZeroMana.LoadBitmap (IDB_ZEROMANA2);
            OneMana.LoadBitmap (IDB_ONEMANA2);
            TwoMana.LoadBitmap (IDB_TWOMANA2);
            ThreeMana.LoadBitmap (IDB_THREEMANA2);
            FourMana.LoadBitmap (IDB_FOURMANA2);
            FiveMana.LoadBitmap (IDB_FIVEMANA2);
            SixMana.LoadBitmap (IDB_SIXMANA2);
            SevenMana.LoadBitmap (IDB_SEVENMANA2);
            EightMana.LoadBitmap (IDB_EIGHTMANA2);
            NineMana.LoadBitmap (IDB_NINEMANA2);
            XMana.LoadBitmap (IDB_XMANA2);
            Tap.LoadBitmap (IDB_TAP2);
        }
    }

    rect = start;
    rect.top = rect.top + (((rect.bottom - rect.top) - BASE) / 2);
    rect.bottom = rect.top + BASE;

    length = 0;

    while (*mana) {
        if (ValidMana (*mana)) {
            switch (*mana) {
                case 'R':
                    DrawBitmap (target, rect, RedMana);
                    break;
                case 'G':
                    DrawBitmap (target, rect, GreenMana);
                    break;
                case 'W':
                    DrawBitmap (target, rect, WhiteMana);
                    break;
                case 'B':
                    DrawBitmap (target, rect, BlackMana);
                    break;
                case 'U':
                    DrawBitmap (target, rect, BlueMana);
                    break;
                case '1':
                    DrawBitmap (target, rect, OneMana);
                    break;
                case '2':
                    DrawBitmap (target, rect, TwoMana);
                    break;
                case '3':
                    DrawBitmap (target, rect, ThreeMana);
                    break;
                case '4':
                    DrawBitmap (target, rect, FourMana);
                    break;
                case '5':
                    DrawBitmap (target, rect, FiveMana);
                    break;
                case '6':
                    DrawBitmap (target, rect, SixMana);
                    break;
                case '7':
                    DrawBitmap (target, rect, SevenMana);
                    break;
                case '8':
                    DrawBitmap (target, rect, EightMana);
                    break;
                case '9':
                    DrawBitmap (target, rect, NineMana);
                    break;
                case '0':
                    DrawBitmap (target, rect, ZeroMana);
                    break;
                case 'X':
                    DrawBitmap (target, rect, XMana);
                    break;
                case 'T':
                    DrawBitmap (target, rect, Tap);
                    break;
            }
            length += BASE;
            rect.left += BASE;
        }
        mana ++;
    }
    return length;
}

// card line

static void DrawAbilities (epp_Context& dc, RECT& rect, CARD_INFO& card)
{
    static epp_Font Font;
    char abilities [20];
    int index;

    if (!Font) {
        char name [256];
        LoadString (IDS_FONTNAME, name);
        Font.Create (BASE, FW_NORMAL, FALSE, FALSE, SYMBOL_CHARSET, name);
    }

    index = 0;

    if (card.Abilities & PROTECTION)
        abilities [index++] = 35;
    if (card.Abilities & REGENERATE)
        abilities [index++] = 34;
    if (card.Abilities & FLYING)
        abilities [index++] = 32;
    if (card.Abilities & LANDWALK)
        abilities [index++] = 39;
    if (card.Abilities & BANDING)
        abilities [index++] = 33;
    if (card.Abilities & FLANKING)
        abilities [index++] = 41;
    if (card.Abilities & FIRSTSTRIKE)
        abilities [index++] = 36;
    if (card.Abilities & TRAMPLE)
        abilities [index++] = 37;
    if (card.Abilities & RAMPAGE)
        abilities [index++] = 38;
    if (card.Abilities & PHASING)
        abilities [index++] = 40;

    rect.right = rect.left + (BASE * MAXABILITIES);
    dc.SelectObject (Font);
    dc.DrawText (abilities, index, &rect, DT_LEFT | DT_VCENTER | DT_NOPREFIX);
}

void DrawCardLine (epp_Context& target, const RECT& area, CARD_INFO& card, int count, BOOL selected)
{
    static epp_CustomContext Buffer;
    static epp_Bitmap BufferBitmap;
    static epp_Font Font;
    char name [256];
    RECT rect;

    if (!Buffer) {
        BufferBitmap.CreateCompatibleBitmap (target, LINEWIDTH, LINEHEIGHT);
        Buffer.CreateCompatibleDC (target);
        Buffer.SelectObject (BufferBitmap);
        Buffer.SetBkMode (TRANSPARENT);
        char name [256];
        LoadString (IDS_LISTFONT, name);
        Font.Create (BASE, name);
    }

    Buffer.SetTextColor (target.GetTextColor ());

    rect.left = 0;
    rect.top = 0;
    rect.right = LINEWIDTH + 1;
    rect.bottom = LINEHEIGHT + 1;
    Buffer.FillRect (&rect, target.GetCurrentObject (OBJ_BRUSH));
    rect.right --;
    rect.bottom --;

    rect.left += BASE / 2;
    rect.left += (BASE * MAXCAST) - ManaWidth (card.Cast);
    rect.left += DrawMana (Buffer, rect, card.Cast);
    rect.left += BASE;


    if (count > 1)
        sprintf (name, "%s (%i)", card.Name, count);
    else
        strcpy (name, card.Name);

    Buffer.SelectObject (Font);
    rect.right = rect.left + WIDTH1;
    Buffer.DrawText (name, -1, &rect, DT_LEFT | DT_VCENTER | DT_NOPREFIX);

    rect.left += WIDTH1;
    rect.right = rect.left + WIDTH1;
    Buffer.DrawText (card.Type, -1, &rect, DT_LEFT | DT_VCENTER | DT_NOPREFIX);
    rect.left += WIDTH1;

    if (*card.Power || *card.Tough) {
        rect.right = rect.left + WIDTH2;
        Buffer.DrawText (card.Power, -1, &rect, DT_RIGHT | DT_VCENTER | DT_NOPREFIX);
        rect.left += WIDTH2;
        rect.right = rect.left + WIDTH3;
        Buffer.DrawText ("/", -1, &rect, DT_CENTER | DT_VCENTER | DT_NOPREFIX);
        rect.left += WIDTH3;
        rect.right = rect.left + WIDTH2;
        Buffer.DrawText (card.Tough, -1, &rect, DT_LEFT | DT_VCENTER | DT_NOPREFIX);
        rect.left += WIDTH2;
    } else
        rect.left += WIDTH2 + WIDTH3 + WIDTH2;

    DrawAbilities (Buffer, rect, card);

    if (selected) {
        rect.left = 0;
        rect.right = LINEWIDTH;
        if (area.right < rect.right)
            rect.right = area.right;
        Buffer.DrawFocusRect (&rect);
    }

    target.BitBlt (area.left, area.top, area.right - area.left, area.bottom - area.top, Buffer, 0, 0, SRCCOPY);
}

// card details

static const char BEGMANA = '<';
static const char ENDMANA = '>';
static int Widths [256];

static int MeasureWord (const char *ptr, BOOL& inmana)
{
    int length;
    BOOL done;
    char c;

    done = FALSE;
    length = 0;

    while (*ptr && !done) {
        c = *ptr++;
        if (inmana)
            if (c == ENDMANA)
                inmana = FALSE;
            else {
                if (ValidMana (c))
                    length += BASE;
            }
        else
            switch (c) {
                case BEGMANA:
                    inmana = TRUE;
                    break;
                case ' ':
                    done = TRUE;
                    break;
                default:
                    length += Widths [c];
                    break;
            }
    }
    return length;
}

static const char * DrawWord (epp_Context& dc, RECT& rect, const char *ptr, BOOL& inmana)
{
    char tempstr [2];
    int width, remain;
    BOOL done;
    char c;

    done = FALSE;
    tempstr [1] = NULL;
    remain = rect.right - rect.left;

    while (*ptr && !done) {
        c = *ptr;
        tempstr [0] = c;
        if (inmana)
            if (c == ENDMANA)
                inmana = FALSE;
            else {
                if (ValidMana (c))
                    if (remain >= BASE) {
                        DrawMana (dc, rect, tempstr);
                        rect.left += BASE;
                        remain -= BASE;
                    } else
                        done = TRUE;
            }
        else
            switch (c) {
                case BEGMANA:
                    inmana = TRUE;
                    break;
                case ' ':
                    done = TRUE;
                    break;
                default:
                    width = Widths [c];
                    if (remain >= width) {
                        dc.DrawText (tempstr, 1, &rect, DT_LEFT | DT_VCENTER);
                        rect.left += width;
                        remain -= width;
                    } else
                        done = TRUE;
                    break;
            }

        if (!done)
            ptr ++;
    }
    return ptr;
}

static const char * DrawSpace (epp_Context& dc, RECT& rect, const char *ptr)
{
    char tempstr [2];
    int remain, width;

    width = Widths [' '];

    tempstr [0] = ' ';
    tempstr [1] = NULL;
    remain = rect.right - rect.left;

    while (*ptr && (*ptr == ' ')) {
        if (remain >= width) {
            dc.DrawText (tempstr, 1, &rect, DT_LEFT | DT_VCENTER);
            rect.left += width;
            remain -= width;
        }
        ptr ++;
    }

    return ptr;
}

static void DrawWords (epp_Context& dc, RECT& area, const char *words, int& lines, BOOL& more)
{
    RECT rect;
    int length;
    BOOL inmana;

    more = FALSE;
    lines = 0;

    if (!*words)
        return;

    inmana = FALSE;
    lines++;

    rect.top = area.top;
    rect.bottom = rect.top + LINEHEIGHT;
    rect.left = area.left;
    rect.right = area.right;

    while (*words) {
        if (rect.left != area.left) {
            length = MeasureWord (words, inmana);
            if (length > (rect.right - rect.left)) {
                rect.top += LINEHEIGHT;;
                rect.bottom += LINEHEIGHT;;
                rect.left = area.left;
                if (rect.bottom > area.bottom) {
                    more = TRUE;
                    return;
                }
                lines ++;
            }
        }
        words = DrawWord (dc, rect, words, inmana);
        if (!inmana && *words == ' ')
            words = DrawSpace (dc, rect, words);
    }
    return;
}

void DrawCardDetails (epp_PaintContext& dc, const RECT& area, CARD_INFO& card)
{
    static epp_Font Font;
    static epp_Font Font2;
    static epp_Brush Brush;
    PAINTSTRUCT paint;
    RECT top, middle, bottom, dummy;

    if (!Font) {
        char name [256];
        LoadString (IDS_DETAILSFONT, name);
        Font.Create (BASE, FW_BOLD, name);
        Font2.Create (BASE, FW_NORMAL, name);
        dc.SelectObject (Font2);
        dc.GetCharWidth (0, 255, Widths);
        Brush.CreateSolidBrush (GetSysColor (COLOR_WINDOW));
    }

    dc.SetBkMode (TRANSPARENT);

    // calculate rectangles

    top.left = BASE / 2;
    top.right = area.right - top.left;
    top.top = BASE / 2;
    top.bottom = top.top + (LINEHEIGHT * 2);

    bottom.left = top.left;
    bottom.right = top.right;
    bottom.bottom = area.bottom - (BASE / 2);
    bottom.top = bottom.bottom - (LINEHEIGHT * 2);

    middle.left = top.left;
    middle.right = top.right;
    middle.top = top.bottom + LINEHEIGHT;
    middle.bottom = bottom.top - 1;

    paint = dc;

    // draw top

    if (IntersectRect (&dummy, &paint.rcPaint, &top)) {
        top.bottom = top.top + LINEHEIGHT;
        dc.SelectObject (Font);
        dc.DrawText (card.Name, -1, &top, DT_LEFT | DT_VCENTER);
        OffsetRect (&top, 0, LINEHEIGHT);
        dc.SelectObject (Font2);
        dc.DrawText (card.Type, -1, &top, DT_LEFT | DT_VCENTER);
        dc.DrawText (card.Freq, -1, &top, DT_RIGHT | DT_VCENTER);
        OffsetRect (&top, 0, -LINEHEIGHT);
        top.left = top.right - ManaWidth (card.Cast);
        DrawMana (dc, top, card.Cast);
    }

    // draw middle

    int lines;
    BOOL drawbottom, more;
    BOOL more1, more2;

    more = FALSE;
    drawbottom = IntersectRect (&dummy, &paint.rcPaint, &bottom);

    if ((middle.bottom - middle.top) >= LINEHEIGHT) {
        if (drawbottom || IntersectRect (&dummy, &paint.rcPaint, &middle)) {    // if bottom, draw to set 'more'
            dc.MoveToEx (middle.left, middle.top - (LINEHEIGHT / 2));
            dc.LineTo (middle.right, middle.top - (LINEHEIGHT / 2));
            dc.SelectObject (Font2);
            DrawWords (dc, middle, card.Spec, lines, more1);
            if (lines)
                middle.top += (lines * LINEHEIGHT) + (BASE / 2);
            if ((middle.bottom - middle.top) >= LINEHEIGHT)
                DrawWords (dc, middle, card.Desc, lines, more2);
            else
                more2 = (*card.Desc)? TRUE : FALSE;

            more = more1 || more2;
            }
        }

    // draw bottom

    if (bottom.top > top.bottom)
        if (drawbottom) {
            dc.MoveToEx (bottom.left, bottom.top + (LINEHEIGHT / 2));
            dc.LineTo (bottom.right, bottom.top + (LINEHEIGHT / 2));

            if (more) {
                POINT verts [3];
                verts [0].x = bottom.right - (BASE / 2);
                verts [0].y = bottom.top + (LINEHEIGHT / 4);
                verts [1].x = bottom.right;
                verts [1].y = verts [0].y;
                verts [2].x = bottom.right - (BASE / 4);
                verts [2].y = verts [0].y + (LINEHEIGHT / 2);

                dc.SelectObject (Brush);
                dc.SetPolyFillMode (WINDING);
                dc.Polygon (verts, 3);
            }

            bottom.top += LINEHEIGHT;

            if (*card.Power || *card.Tough) {
                char combined [20];
                sprintf (combined, "%s / %s", card.Power, card.Tough);
                dc.SelectObject (Font2);
                dc.DrawText (combined, -1, &bottom, DT_RIGHT | DT_VCENTER);
            }
        }
}