//////////////////
// Dialog Boxes //
//////////////////

#pragma once
#include "Global.h"

class GlobalDialog : public epp_Dialog
{
    public:

        BOOL Run (int id, HWND parent);
};


class FindDialog : GlobalDialog
{
    public:

        BOOL Run (HWND, const char *);

        operator const char * ();

    private:

        BOOL OnInitDialog (HWND, LPARAM);
        void OnOkay ();

        char _Find [256];

    DECLARE_HANDLER
};

inline FindDialog::operator const char * ()
    { return _Find; }

class RenameDialog : GlobalDialog
{
    public:

        BOOL Run (HWND, const char *, BOOL);

        const char * GetName ();
        BOOL GetSave ();

    private:

        BOOL OnInitDialog (HWND, LPARAM);
        void OnOkay ();

        char _Name [256];
        BOOL _Save;

    DECLARE_HANDLER
};

inline const char * RenameDialog::GetName ()
    { return _Name; }

inline BOOL RenameDialog::GetSave ()
    { return _Save; }


class SearchDialog : public GlobalDialog
{
    public:

        BOOL Run (HWND, const char *);

        operator const CARD_SEARCH * ();

    private:

        void CheckAll (int);
        void SetPage (int cur);
        void SetPageItem (int id, int page, int cur);

        void OnCommand (int, int, HWND);
        BOOL OnInitDialog (HWND, LPARAM);
        void OnNotify (int, NMHDR *);
        void OnOkay ();

        char _Title [256];
        CARD_SEARCH Search;

    DECLARE_HANDLER
};

inline SearchDialog::operator const CARD_SEARCH * ()
    { return &Search; }

class UnlockDialog : public GlobalDialog
{
    public:

        BOOL Run (HWND parent);
};

class AboutDialog : public GlobalDialog
{
    public:

        BOOL Run (HWND parent);

    private:

        BOOL OnInitDialog (HWND, LPARAM);

    DECLARE_HANDLER
};

class CardDialog : public GlobalDialog
{
    public:

        BOOL Run (CARD_INFO*, HWND);

    private:

        BOOL OnInitDialog (HWND, LPARAM);
        void OnOkay ();

        CARD_INFO *_Data;

    DECLARE_HANDLER
};

class ImportDialog : public epp_OpenDialog
{
    public:

        BOOL Run (HWND parent);
};

class ImportDeckDialog : public epp_OpenDialog
{
    public:

        BOOL Run (HWND parent);
};

class ExportDeckDialog : public epp_SaveDialog
{
    public:

        BOOL Run (const char *, HWND parent);
};

void BusyBegin (int id, HWND switchto);
void BusyEnd ();

BOOL Check (const char *confirm, HWND parent);
void Error (const char *message, int flag);