//////////////////
// Dialog Boxes //
//////////////////

#include "View List.h"
#include "Dialogs.h"
#include <dlgs.h>
#include <stdio.h>
#include <string.h>

BOOL GlobalDialog::Run (int id, HWND parent)
{
    Views.Enable (FALSE);
    DialogBoxParam (id, parent);
    Views.Enable (TRUE);
    return OK ();
}

BOOL RenameDialog::Run (HWND parent, const char *name, BOOL save)
{
    strcpy (_Name, name);
    _Save = save;
    return GlobalDialog::Run (IDD_RENAME, parent);
}

BOOL RenameDialog::OnInitDialog (HWND, LPARAM)
{
    epp_Edit edit;
    epp_Button check;

    edit.Attach (GetDlgItem (IDC_NAME));
    edit.SetText (_Name);
    edit.SetSel (-1, -1);

    check.Attach (GetDlgItem (IDC_SAVE));
    check.SetCheck ((_Save)? 1 : 0);
    if (_Save)
        check.EnableWindow (FALSE);

    return TRUE;
}

void RenameDialog::OnOkay ()
{
    GetDlgItemText (IDC_NAME, _Name, sizeof (_Name));
    _Save = IsDlgButtonChecked (IDC_SAVE);
}

BEGIN_HANDLER (RenameDialog, GlobalDialog)
    ON_WM_INITDIALOG
END_HANDLER

BOOL FindDialog::Run (HWND parent, const char *start)
{
    strcpy (_Find, start);
    return GlobalDialog::Run (IDD_FIND, parent);
}

BOOL FindDialog::OnInitDialog (HWND, LPARAM)
{
    epp_Edit edit;

    edit.Attach (GetDlgItem (IDC_NAME));
    edit.SetText (_Find);

    return TRUE;
}

void FindDialog::OnOkay ()
{
    GetDlgItemText (IDC_NAME, _Find, sizeof (_Find));
}

BEGIN_HANDLER (FindDialog, GlobalDialog)
    ON_WM_INITDIALOG
END_HANDLER

static void SetFlag (int state, int flag, int& set, int& clear)
{
    if (state == 0)
        clear |= flag;
    else
        if (state == 1)
            set |= flag;
}

BOOL SearchDialog::Run (HWND parent, const char *title)
{
    wsprintf (_Title, "Dexter - %s", title);
    return GlobalDialog::Run (IDD_SEARCH, parent);
}

void SearchDialog::CheckAll (int check)
{
    CheckDlgButton (IDC_RED, check);
    CheckDlgButton (IDC_GREEN, check);
    CheckDlgButton (IDC_WHITE, check);
    CheckDlgButton (IDC_BLACK, check);
    CheckDlgButton (IDC_BLUE, check);
    CheckDlgButton (IDC_MULTI, check);
    CheckDlgButton (IDC_COLORLESS, check);
    CheckDlgButton (IDC_SUMMON, check);
    CheckDlgButton (IDC_ENCHANTMENT, check);
    CheckDlgButton (IDC_SORCERY, check);
    CheckDlgButton (IDC_INSTANT, check);
    CheckDlgButton (IDC_INTERRUPT, check);
    CheckDlgButton (IDC_ARTIFACT, check);
    CheckDlgButton (IDC_LAND, check);
    CheckDlgButton (IDC_CREATURE, check);
    CheckDlgButton (IDC_PERMANENT, check);
    CheckDlgButton (IDC_FASTEFFECT, check);
    CheckDlgButton (IDC_FLYING, check);
    CheckDlgButton (IDC_LANDWALK, check);
    CheckDlgButton (IDC_PROTECTION, check);
    CheckDlgButton (IDC_BANDING, check);
    CheckDlgButton (IDC_FIRSTSTRIKE, check);
    CheckDlgButton (IDC_TRAMPLE, check);
    CheckDlgButton (IDC_RAMPAGE, check);
    CheckDlgButton (IDC_REGENERATE, check);
    CheckDlgButton (IDC_PHASING, check);
    CheckDlgButton (IDC_FLANKING, check);
    CheckDlgButton (IDC_UL, check);
    CheckDlgButton (IDC_RV, check);
    CheckDlgButton (IDC_4E, check);
    CheckDlgButton (IDC_5E, check);
    CheckDlgButton (IDC_AI, check);
    CheckDlgButton (IDC_AN, check);
    CheckDlgButton (IDC_AQ, check);
    CheckDlgButton (IDC_CH, check);
    CheckDlgButton (IDC_DK, check);
    CheckDlgButton (IDC_FE, check);
    CheckDlgButton (IDC_HL, check);
    CheckDlgButton (IDC_IA, check);
    CheckDlgButton (IDC_LG, check);
    CheckDlgButton (IDC_MI, check);
    CheckDlgButton (IDC_TE, check);
    CheckDlgButton (IDC_VI, check);
    CheckDlgButton (IDC_WL, check);
    CheckDlgButton (IDC_P, check);
}

void SearchDialog::OnCommand (int, int id, HWND)
{
    if (id == IDC_CLEARALL)
        CheckAll (2);
    else
        Forward ();
}

BOOL SearchDialog::OnInitDialog (HWND, LPARAM)
{
    epp_TabControl tab;

    SetWindowText (_Title);
    CheckDlgButton (IDC_NAMEANYWHERE, 1);
    CheckDlgButton (IDC_TYPEANYWHERE, 1);
    CheckDlgButton (IDC_WITHOUT, 0);
    CheckAll (2);

    tab.Attach (GetDlgItem (IDC_SEARCHFOR));
    tab.InsertItem (0, "Color");
    tab.InsertItem (1, "Type");
    tab.InsertItem (2, "Ability");
    tab.InsertItem (3, "Edition");
    SetPage (0);

    return TRUE;
}

void SearchDialog::SetPageItem (int id, int page, int cur)
{
    ::ShowWindow (GetDlgItem (id), (page == cur)? SW_SHOW : SW_HIDE);
}

void SearchDialog::SetPage (int cur)
{
    SetPageItem (IDC_RED, 0, cur);
    SetPageItem (IDC_GREEN, 0, cur);
    SetPageItem (IDC_WHITE, 0, cur);
    SetPageItem (IDC_BLACK, 0, cur);
    SetPageItem (IDC_BLUE, 0, cur);
    SetPageItem (IDC_MULTI, 0, cur);
    SetPageItem (IDC_COLORLESS, 0, cur);
    SetPageItem (IDC_SUMMON, 1, cur);
    SetPageItem (IDC_ENCHANTMENT, 1, cur);
    SetPageItem (IDC_SORCERY, 1, cur);
    SetPageItem (IDC_INSTANT, 1, cur);
    SetPageItem (IDC_INTERRUPT, 1, cur);
    SetPageItem (IDC_ARTIFACT, 1, cur);
    SetPageItem (IDC_LAND, 1, cur);
    SetPageItem (IDC_CREATURE, 1, cur);
    SetPageItem (IDC_PERMANENT, 1, cur);
    SetPageItem (IDC_FASTEFFECT, 1, cur);
    SetPageItem (IDC_FLYING, 2, cur);
    SetPageItem (IDC_LANDWALK, 2, cur);
    SetPageItem (IDC_PROTECTION, 2, cur);
    SetPageItem (IDC_BANDING, 2, cur);
    SetPageItem (IDC_FIRSTSTRIKE, 2, cur);
    SetPageItem (IDC_TRAMPLE, 2, cur);
    SetPageItem (IDC_RAMPAGE, 2, cur);
    SetPageItem (IDC_REGENERATE, 2, cur);
    SetPageItem (IDC_PHASING, 2, cur);
    SetPageItem (IDC_FLANKING, 2, cur);
    SetPageItem (IDC_UL, 3, cur);
    SetPageItem (IDC_RV, 3, cur);
    SetPageItem (IDC_4E, 3, cur);
    SetPageItem (IDC_5E, 3, cur);
    SetPageItem (IDC_AI, 3, cur);
    SetPageItem (IDC_AN, 3, cur);
    SetPageItem (IDC_AQ, 3, cur);
    SetPageItem (IDC_CH, 3, cur);
    SetPageItem (IDC_DK, 3, cur);
    SetPageItem (IDC_FE, 3, cur);
    SetPageItem (IDC_HL, 3, cur);
    SetPageItem (IDC_IA, 3, cur);
    SetPageItem (IDC_LG, 3, cur);
    SetPageItem (IDC_MI, 3, cur);
    SetPageItem (IDC_TE, 3, cur);
    SetPageItem (IDC_VI, 3, cur);
    SetPageItem (IDC_WL, 3, cur);
    SetPageItem (IDC_P, 3, cur);
}

void SearchDialog::OnNotify (int, NMHDR *hdr)
{
    epp_TabControl tab;

    if (hdr->code == TCN_SELCHANGE) {
        tab.Attach (GetDlgItem (IDC_SEARCHFOR));
        SetPage (tab.GetCurSel ());
    }
}

void SearchDialog::OnOkay ()
{
    GetDlgItemText (IDC_NAME, Search.Name, sizeof (Search.Name));
    GetDlgItemText (IDC_TYPE, Search.Type, sizeof (Search.Type));
    GetDlgItemText (IDC_ABILITIES, Search.Spec, sizeof (Search.Spec));
    GetDlgItemText (IDC_DESCRIPTION, Search.Desc, sizeof (Search.Desc));
    Search.NameAnywhere = IsDlgButtonChecked (IDC_NAMEANYWHERE);
    Search.TypeAnywhere = IsDlgButtonChecked (IDC_TYPEANYWHERE);
    Search.SkipMatch = IsDlgButtonChecked (IDC_WITHOUT);

    Search.SetFlags = 0;
    Search.ClearFlags = 0;

    SetFlag (IsDlgButtonChecked (IDC_RED), RED, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_GREEN), GREEN, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_WHITE), WHITE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_BLACK), BLACK, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_BLUE), BLUE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_MULTI), MULTICOLOR, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_COLORLESS), COLORLESS, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_SUMMON), SUMMON, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_ENCHANTMENT), ENCHANTMENT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_SORCERY), SORCERY, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_INSTANT), INSTANT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_INTERRUPT), INTERRUPT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_ARTIFACT), ARTIFACT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_LAND), LAND, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_CREATURE), CREATURE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_PERMANENT), PERMANENT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_FASTEFFECT), FASTEFFECT, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_FLYING), FLYING, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_LANDWALK), LANDWALK, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_PROTECTION), PROTECTION, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_BANDING), BANDING, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_FIRSTSTRIKE), FIRSTSTRIKE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_TRAMPLE), TRAMPLE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_RAMPAGE), RAMPAGE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_REGENERATE), REGENERATE, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_FLANKING), FLANKING, Search.SetFlags, Search.ClearFlags);
    SetFlag (IsDlgButtonChecked (IDC_PHASING), PHASING, Search.SetFlags, Search.ClearFlags);

    Search.SetEdition = 0;
    Search.ClearEdition = 0;

    SetFlag (IsDlgButtonChecked (IDC_UL), ED_UL, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_RV), ED_RV, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_4E), ED_4E, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_5E), ED_5E, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_AI), ED_AI, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_AN), ED_AN, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_AQ), ED_AQ, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_CH), ED_CH, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_DK), ED_DK, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_FE), ED_FE, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_HL), ED_HL, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_IA), ED_IA, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_LG), ED_LG, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_MI), ED_MI, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_TE), ED_TE, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_VI), ED_VI, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_WL), ED_WL, Search.SetEdition, Search.ClearEdition);
    SetFlag (IsDlgButtonChecked (IDC_P), ED_P, Search.SetEdition, Search.ClearEdition);

    strupr (Search.Name);
    strupr (Search.Type);
    strupr (Search.Spec);
    strupr (Search.Desc);
}

BEGIN_HANDLER (SearchDialog, GlobalDialog)
    ON_WM_COMMAND
    ON_WM_NOTIFY
    ON_WM_INITDIALOG
END_HANDLER

static class BusyFrame : public epp_Frame
{
    public:

        void Create (int messageid, HWND switchto);

     private:

        int OnCreate (CREATESTRUCT *);
        void OnDestroy ();
        BOOL OnEraseBkgnd (HDC);
        void OnPaint ();

        epp_Brush _Brush;
        epp_Font _Font;
        epp_Animate _Animate;
        HWND _SwitchTo;
        RECT _MessageRect;
        char _MessageText [256];
        int _MessageId;

    DECLARE_HANDLER
} Busy;

BEGIN_HANDLER (BusyFrame, epp_Frame)
    ON_WM_PAINT
    ON_WM_ERASEBKGND
    ON_WM_CREATE
    ON_WM_DESTROY
END_HANDLER

void BusyFrame::Create (int messageid, HWND switchto)
{
    RECT rect;

    _MessageId = messageid;
    _SwitchTo = switchto;

    rect.left = GetSystemMetrics (SM_CXSCREEN) / 5;
    rect.right = rect.left * 4;
    rect.top = (GetSystemMetrics (SM_CYSCREEN) - (ANIMATEY * 3)) / 2;
    rect.bottom = rect.top + (ANIMATEY * 3);

    epp_Frame::Create (0, "Dexter - Working", WS_POPUP | WS_DLGFRAME | WS_CAPTION | WS_CLIPCHILDREN | WS_VISIBLE, rect);
    UpdateWindow ();
}

int BusyFrame::OnCreate (CREATESTRUCT *)
{
    char message [256];
    RECT rect, arect;
    COLORREF back;

    Views.Enable (FALSE);
    GetClientRect (&rect);

    back = GetSysColor (COLOR_WINDOW);
    _Brush.CreateSolidBrush (back);
    LoadString (IDS_BUSYFONT, message);
    _Font.Create (BASE, FW_BOLD, message);

    LoadString (_MessageId, _MessageText);

    _MessageRect.left = ANIMATEX * 2;
    _MessageRect.right = rect.right - (ANIMATEX * 2);
    _MessageRect.top = (rect.bottom - BASE) / 2;
    _MessageRect.bottom = _MessageRect.top + BASE;

    arect.left = rect.right - (ANIMATEX + (ANIMATEX / 2));
    arect.right = arect.left + ANIMATEX;
    arect.top = (rect.bottom - ANIMATEY) / 2;
    arect.bottom = arect.top + ANIMATEY;
    _Animate.Create (IDB_SPIN, IDB_SPINMASK, back, ANIFRAMES, ANISPEED, WS_VISIBLE, arect, *this);

    return 0;
}

void BusyFrame::OnDestroy ()
{
    _Animate.Close ();
    _Font.Close ();
    _Brush.Close ();
    Views.Enable (TRUE);

    ::SetForegroundWindow (_SwitchTo);
}

BOOL BusyFrame::OnEraseBkgnd (HDC dc)
{
    epp_Context context;
    RECT rect;

    GetClientRect (&rect);
    ::FillRect (dc, &rect, _Brush);

    return TRUE;
}

void BusyFrame::OnPaint ()
{
    epp_PaintContext dc;

    dc.BeginPaint (*this);
    dc.SelectObject (_Font);
    dc.SetBkMode (TRANSPARENT);
    dc.DrawText (_MessageText, -1, &_MessageRect, DT_CENTER | DT_VCENTER);
}

void BusyBegin (int id, HWND switchto)
{
    Busy.Create (id, switchto);
}

void BusyEnd ()
{
    Busy.PostMessage (WM_CLOSE, 0, 0);
}

static class ConfirmDialog : public GlobalDialog
{
    public:

        BOOL Run (const char *message, HWND parent);

        BOOL OnInitDialog (HWND, LPARAM);

     private:

        char _Query [256];

    DECLARE_HANDLER

} Confirm;

BEGIN_HANDLER (ConfirmDialog, GlobalDialog)
    ON_WM_INITDIALOG
END_HANDLER

BOOL ConfirmDialog::Run (const char *message, HWND parent)
{
    strcpy (_Query, message);
    return GlobalDialog::Run (IDD_CONFIRM, parent);
}

BOOL ConfirmDialog::OnInitDialog (HWND, LPARAM)
{
    SetDlgItemText (IDC_MESSAGE, _Query);
    return TRUE;
}

BOOL Check (const char *message, HWND parent)
{
    return Confirm.Run (message, parent);
}

BOOL UnlockDialog::Run (HWND parent)
{
    return GlobalDialog::Run (IDD_UNLOCK, parent);
}

BOOL AboutDialog::Run (HWND parent)
{
    return GlobalDialog::Run (IDD_ABOUT, parent);
}

BOOL AboutDialog::OnInitDialog (HWND, LPARAM)
{
    char verstr [256];

    sprintf (verstr, "Version %i.%02i", VERSION_MAJOR, VERSION_MINOR);
    SetDlgItemText (IDC_VERSION, verstr);
    return TRUE;
}

BEGIN_HANDLER (AboutDialog, GlobalDialog)
    ON_WM_INITDIALOG
END_HANDLER

BOOL CardDialog::Run (CARD_INFO *data, HWND parent)
{
    _Data = data;
    return GlobalDialog::Run (IDD_CARD, parent);
}

BOOL CardDialog::OnInitDialog (HWND, LPARAM)
{
    SetDlgItemText (IDC_NAME, _Data->Name);
    SetDlgItemText (IDC_TYPE, _Data->Type);
    SetDlgItemText (IDC_CAST, _Data->Cast);
    SetDlgItemText (IDC_POWER, _Data->Power);
    SetDlgItemText (IDC_TOUGHNESS, _Data->Tough);
    SetDlgItemText (IDC_ABILITIES, _Data->Spec);
    SetDlgItemText (IDC_DESCRIPTION, _Data->Desc);
    SetDlgItemText (IDC_EDITION, _Data->Freq);
    return TRUE;
}

void CardDialog::OnOkay ()
{
    GetDlgItemText (IDC_NAME, _Data->Name, sizeof (_Data->Name));
    GetDlgItemText (IDC_TYPE, _Data->Type, sizeof (_Data->Type));
    GetDlgItemText (IDC_CAST, _Data->Cast, sizeof (_Data->Cast));
    GetDlgItemText (IDC_POWER, _Data->Power, sizeof (_Data->Power));
    GetDlgItemText (IDC_TOUGHNESS, _Data->Tough, sizeof (_Data->Tough));
    GetDlgItemText (IDC_ABILITIES, _Data->Spec, sizeof (_Data->Spec));
    GetDlgItemText (IDC_DESCRIPTION, _Data->Desc, sizeof (_Data->Desc));
    GetDlgItemText (IDC_EDITION, _Data->Freq, sizeof (_Data->Freq));
}

BEGIN_HANDLER (CardDialog, GlobalDialog)
    ON_WM_INITDIALOG
END_HANDLER

BOOL ImportDialog::Run (HWND parent)
{
    const char *Filter = "Text Files (*.txt)\000*.txt\000All Files (*.*)\000*.*\000\000";
    return Create (OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_EXPLORER, 0, "Import Cards", NULL, NULL, NULL, Filter, 2, parent);
}

BOOL ImportDeckDialog::Run (HWND parent)
{
    const char *Filter = "Text Files (*.txt)\000*.txt\000All Files (*.*)\000*.*\000\000";
    return Create (OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_EXPLORER, 0, "Import Deck", NULL, NULL, "txt", Filter, 1, parent);
}

BOOL ExportDeckDialog::Run (const char *defname, HWND parent)
{
    const char *Filter = "Text Files (*.txt)\000*.txt\000All Files (*.*)\000*.*\000\000";
    return Create (OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_EXPLORER, 0, "Export Deck", defname, NULL, "txt", Filter, 1, parent);
}

void Error (const char *message, int flags)
{
    MessageBox (NULL, message, "Dexter - Error", MB_OK | MB_SETFOREGROUND | flags);
}