// DEXTER.CPP
// by Eric Tauck
//
// A program for building "Magic: The Gathering" decks.

// Possible features:
//
// - "Mana Source" card type (i.e. Dark Ritual)
// - Check if not enough memory
// - Option to port custom cards during upgrade: save list of
//   cards carried over but not in library.
// - Cascade windows: search windows from left and cards from
//   right
// - Print decks
// - Rulings
// - Card point values
// - Scrollable card description area, or maybe if click triangle,
//   zoom to card text
// - horizontal scroll on deck
// - Redo some layouts for lo-res (like the search window)
// - Search for COMMON, UNCOMMON, RARE, EXTRA COMMON, and LAND
// - Card "trash can" to remove card from deck
// - Automatically start card search in list window when
//   a letter is typed (did it, but removed it -- the list
//   window loses focus when a dragged card is dropped)
// - On card search, if only one card is found, go right to card
// - Deck search: optionally add search results to current
//   window or replace current window with search results
// - Display deck statistics: how many cards of each color
//   and type, point total, expansions, tournament legality,
//   number of unique cards
// - Symbol for upkeep and cumulative upkeep
// - Save (open) searches and cards, and automatically
//   restore (i.e. open) windows
// - Maybe try to remove decks and cards from task bar
//   (can do it by making windows children of view list, but
//   then view list can't appear over deck or card window)
// - Put icon for deck/search/card in view window
// - Pop-Up description of card set (d = The Dark,
//   g--- = 4th Ed., etc) and frequency; OR, maybe interpret
//   string more graphically
// - Empty decks: maybe delete on close and/or don't save
//   (probably not -- already allow delete without confirm)
// - More control over sort order: enable, disable, and set
//   order priority for COLOR, TYPE, POWER, and TOUGHNESS
// - Quit without saving, and create backup files of decks
// - Insert comments in DAT file showing deck name
// - Display hourglass during some operations
// - Maybe an additional confirmation before loading (i.e.
//   importing) cards
// - Deck notes
// - Merge/Duplicate decks
// - Import additional deck type.
// - After importing cards, the color/type order might
//   change (the name can't change) -- all decks with
//   this sort order should be resorted
// - Center common dialogs (MS made it hard for dialogs
//   with the explorer style)
// - When importing cards, show existing cards actually
//   updated (i.e. changed)
// - Help: list of other programs in secret topic; use those
//   cute little buttons for "Related Topics".
// - Overwrite warning on export.
//
// Notes:
//
// - Sort by type order:
//        COLOR (RED, GREEN, WHITE, BLACK, MULTI, ARTIFACT)
//            CREATURE
//                POWER
//                    TOUGHNESS
//            SPELLS
//        LAND
// - When deck or card is opened, main list goes to  bottom
//   of z-order.  However, when that deck or card is closed,
//   the list pops to the top of the z-order -- may want to
//   remove ordering because of this.
// - After dropping a card in the deck and then clicking the
//   + or - buttons, the tooltips sometimes turn on too soon.
//   Might be because the window was not active when the button
//   was pressed (dropping a card doesn't activate a deck).

#include "View List.h"

///////////////////
// Program Entry //
///////////////////

int epp_Main ()
{
    const char *CLASSNAME = "DexterViewClass";
    epp_Icon Icon;
    epp_Class Class;
    char name [256];
    HWND previous;

    Icon.LoadIcon (IDI_CARDS);
    Class.Create (0, LoadCursor (NULL, IDC_ARROW), NULL, Icon, CLASSNAME);

    LoadString (IDS_MAINTITLE, name);
    previous = FindWindow (CLASSNAME, name);

    if (previous) {
        ShowWindow (previous, SW_NORMAL);
        SetForegroundWindow (previous);
    } else {
        Views.Create (Class, name);
    	Views.UpdateWindow ();

        LoadString (IDS_FONTFILE, name);
        AddFontResource (name);

    	epp_App app;
    	app.Run ();

        RemoveFontResource (name);
    }

	return 0;
}